/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFToUnicodeCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.CharSetEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.StandardCharSetEncodings;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.StandardEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.StandardFontUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PDFFontSimple
extends PDFFont {
    private WeakReference<int[]> standardFontWidthsRef = null;
    private int spaceCharCode = -1;

    protected PDFFontSimple(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public PDFFontSimple(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
    }

    public PDFFontSimple(PDFDocument pdfDoc, Font afeFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc, afeFont);
    }

    public static PDFFontSimple newInstance(PDFDocument pdfDocument, ASName baseFont, ASName subType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontSimple pdfObject = new PDFFontSimple(pdfDocument);
        pdfObject.setDictionaryNameValue(ASName.k_Subtype, subType);
        pdfObject.setBaseFont(baseFont);
        return pdfObject;
    }

    public static PDFFontSimple newInstance(PDFDocument pdfDocument, Font afeFont, ASName subType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        PDFFontDescription pdfDesc = afeFont.getPDFFontDescription();
        ASName baseFont = ASName.create(pdfDesc.getPostscriptName());
        PDFFontSimple pdfObject = new PDFFontSimple(pdfDocument, afeFont);
        pdfObject.setDictionaryNameValue(ASName.k_Subtype, subType);
        pdfObject.setBaseFont(baseFont);
        return pdfObject;
    }

    public static PDFFontSimple getInstance(CosObject cosObject, ASName type) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        if (type == ASName.k_Type3) {
            return PDFFontType3.getInstance(cosObject);
        }
        PDFFontSimple pdfObject = (PDFFontSimple)PDFCosObject.getCachedInstance(cosObject, PDFFontSimple.class);
        if (pdfObject == null) {
            pdfObject = new PDFFontSimple(cosObject);
        }
        return pdfObject;
    }

    public void removeFirstChar() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_FirstChar);
    }

    public void setFirstChar(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_FirstChar, value);
    }

    public void removeLastChar() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_LastChar);
    }

    public void setLastChar(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_LastChar, value);
    }

    public int getFirstChar() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary fontDict = this.getCosDictionary();
        if (fontDict.containsKey(ASName.k_FirstChar)) {
            return fontDict.getInt(ASName.k_FirstChar);
        }
        if (PDFFontUtils.isStandardFont(this.getBaseFont())) {
            return 0;
        }
        throw new PDFInvalidDocumentException("simple font dictionary missing required FirstChar entry");
    }

    public int getLastChar() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary fontDict = this.getCosDictionary();
        CosObject lastChar = fontDict.get(ASName.k_LastChar);
        if (lastChar != null) {
            return lastChar.intValue();
        }
        if (PDFFontUtils.isStandardFont(this.getBaseFont())) {
            return 255;
        }
        throw new PDFInvalidDocumentException("simple font dictionary missing required LastChar entry");
    }

    public void removeWidths() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_Widths);
    }

    public void buildWidths(int firstChar, int lastChar, Font font) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFFontException, PDFInvalidParameterException {
        if (font == null) {
            throw new PDFInvalidParameterException("buildWidths method called with a null font");
        }
        try {
            PDFFontDescription fontDesc = font.getPDFFontDescription();
            CosArray widthsObj = this.getCosObject().getDocument().createCosArray(1);
            FontData fontData = this.getAFEFontData();
            if (fontData == null) {
                fontData = ((FontImpl)font).getFontData();
            }
            for (int i = firstChar; i <= lastChar; ++i) {
                int gid = this.charCode2gid(i, fontData);
                double glyphWidth = gid < 0 ? 0.0 : fontDesc.getAdvance(gid) + 0.5;
                widthsObj.addInt(i - firstChar, (int)glyphWidth);
            }
            this.setDictionaryIntValue(ASName.k_FirstChar, firstChar);
            this.setDictionaryIntValue(ASName.k_LastChar, lastChar);
            this.setDictionaryArrayValue(ASName.k_Widths, widthsObj);
        }
        catch (FontEngineException e) {
            throw new PDFFontException(e);
        }
    }

    public void setWidths(int[] widths, int startPos, int endPos) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (widths == null) {
            throw new PDFInvalidParameterException("setWidths method called with null widths");
        }
        CosArray valueArray = PDFFontSimple.makeCosArray(this.getPDFDocument(), widths, startPos, endPos);
        this.setDictionaryArrayValue(ASName.k_Widths, valueArray);
    }

    public void setWidths(List widths) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (widths == null) {
            throw new IllegalArgumentException("setWidths method called with null widths");
        }
        CosArray valueArray = PDFFontSimple.makeCosArray(this.getPDFDocument(), widths);
        this.setDictionaryArrayValue(ASName.k_Widths, valueArray);
    }

    public int[] getWidths() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary fontDict = this.getCosDictionary();
        int lastChar = this.getLastChar();
        int firstChar = this.getFirstChar();
        int widthsSize = lastChar - firstChar + 1;
        int[] widths = new int[widthsSize];
        CosArray widthsArray = fontDict.getCosArray(ASName.k_Widths);
        if (widthsArray != null) {
            int arraySize = widthsArray.size();
            if (arraySize < widthsSize) {
                throw new PDFInvalidDocumentException("invalid widths table in font dictionary");
            }
            for (int i = 0; i < arraySize; ++i) {
                widths[i] = widthsArray.getInt(i);
            }
        } else if (PDFFontUtils.isStandardFont(this.getBaseFont())) {
            int[] standardWidths = this.getStandardFontWidths();
            if (standardWidths.length == 1) {
                return standardWidths;
            }
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = standardWidths[i + firstChar];
            }
        } else {
            throw new PDFInvalidDocumentException("simple font dictionary missing required Widths entry");
        }
        return widths;
    }

    public int[] getStandardFontWidths() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int[] widths;
        if (this.standardFontWidthsRef != null && (widths = (int[])this.standardFontWidthsRef.get()) != null) {
            return widths;
        }
        widths = StandardFontUtils.getStandardFontWidths(this);
        this.standardFontWidthsRef = new WeakReference<int[]>(widths);
        return widths;
    }

    @Override
    public PDFFontDescriptor getFontDescriptor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary fontDict = this.getCosDictionary();
        CosDictionary cosObj = fontDict.getCosDictionary(ASName.k_FontDescriptor);
        if (cosObj != null) {
            return PDFFontDescriptor.getInstance(cosObj);
        }
        ASName fontName = this.getBaseFont();
        return PDFFontSimple.getStandardFontFontDescriptor(fontName);
    }

    public void setFontDescriptor(PDFFontDescriptor fontDescriptor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosFontDescriptor = fontDescriptor.getPDFCosDescriptor().getCosObject();
        this.getCosDictionary().put(ASName.k_FontDescriptor, cosFontDescriptor);
    }

    public PDFSimpleFontEncoding getEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSimpleFontEncoding encoding = null;
        CosObject cosObj = this.getCosDictionary().get(ASName.k_Encoding);
        if (cosObj != null) {
            encoding = PDFSimpleFontEncoding.getInstance(cosObj);
        }
        return encoding;
    }

    public void setEncoding(PDFSimpleFontEncoding encoding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Encoding, encoding);
    }

    public String getGlyphNameFromImplicitBaseEncoding(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String glyphName = null;
        CharSetEncoding baseEncoding = this.getImplicitBaseEncoding();
        if (baseEncoding != null) {
            glyphName = baseEncoding.getGlyphName(charCode);
        }
        return glyphName;
    }

    public CharSetEncoding getImplicitBaseEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName fontName;
        boolean isSymbolic = false;
        if (this.getFontDescriptor() != null) {
            boolean bl = isSymbolic = (this.getFontDescriptor().getFlags() & 4) != 0;
        }
        if (!((fontName = this.getBaseFont()) != ASName.k_Symbol && fontName != ASName.k_ZapfDingbats && isSymbolic || this.isEmbedded())) {
            return StandardCharSetEncodings.getDefaultCharsetForFont(fontName);
        }
        return null;
    }

    @Override
    public PDFWritingMode getWritingMode() {
        return PDFWritingMode.HORIZONTAL;
    }

    public boolean hasZeroWidth(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (charCode >= this.getFirstChar() && charCode <= this.getLastChar()) {
            return Math.round(this.getGlyphWidth(charCode, false)) == 0L;
        }
        return true;
    }

    @Override
    public double getGlyphWidth(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int charCode = (int)PDFCMapUtils.getCharCode(charCodeBytes);
        return this.getGlyphWidth(charCode, false);
    }

    public double getGlyphWidthDefaultMissingWidth(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int charCode = (int)PDFCMapUtils.getCharCode(charCodeBytes);
        return this.getGlyphWidth(charCode, true);
    }

    public double getGlyphWidth(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getGlyphWidth(charCode, false);
    }

    public double getGlyphWidthDefaultMissingWidth(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getGlyphWidth(charCode, true);
    }

    public double getGlyphWidth(int charCode, boolean defaultMissingWidth) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFontUtils.getGlyphWidth(defaultMissingWidth, this, charCode)[0];
    }

    public double getGlyphWidthFromEmbeddedFontFile(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        byte charCode = charCodeBytes[0];
        return PDFFontUtils.getGlyphWidthFromEmbeddedFontFile(charCode, this);
    }

    public int getCharCodeSize(byte[] charCode) {
        return 1;
    }

    @Override
    public double getGlyphHeight(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getAscent() + Math.abs(this.getDescent());
    }

    @Override
    public double getGlyphDisplacement(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getGlyphWidth(charCode, false);
    }

    @Override
    public double getAscent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double ascend = this.getFontDescriptor().getAscent();
        if (ascend == 0.0) {
            try {
                Rect fontBBox;
                Font f = this.getAFEFont();
                if (f != null && (fontBBox = f.getPDFFontDescription().getFontBBox()) != null) {
                    ASRectangle asrect = PDFFontSimple.getRectangleCoords(fontBBox);
                    ascend = Math.ceil(asrect.top());
                }
            }
            catch (InvalidFontException e) {
                throw new PDFIOException(e);
            }
            catch (UnsupportedFontException e) {
                throw new PDFIOException(e);
            }
            catch (FontLoadingException e) {
                throw new PDFIOException(e);
            }
        }
        return ascend;
    }

    @Override
    public double getDescent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double descent = this.getFontDescriptor().getDescent();
        if (descent == 0.0) {
            try {
                Font f = this.getAFEFont();
                if (f != null) {
                    ASRectangle asrect = PDFFontSimple.getRectangleCoords(f.getPDFFontDescription().getFontBBox());
                    descent = Math.floor(asrect.bottom());
                }
            }
            catch (InvalidFontException e) {
                throw new PDFIOException(e);
            }
            catch (UnsupportedFontException e) {
                throw new PDFIOException(e);
            }
            catch (FontLoadingException e) {
                throw new PDFIOException(e);
            }
        }
        return descent;
    }

    @Override
    public ASRectangle getBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASRectangle cosfontBBox = null;
        PDFFontDescriptor pdfFontDescriptor = this.getFontDescriptor();
        if (pdfFontDescriptor != null) {
            cosfontBBox = pdfFontDescriptor.getFontBBox();
        }
        if (cosfontBBox == null) {
            try {
                FontData fdata = this.getAFEFontData();
                if (fdata == null) {
                    return null;
                }
                Rect fontBBox = fdata.getFontBBox();
                return new ASRectangle(fontBBox.xmin, fontBBox.ymin, fontBBox.xmax, fontBBox.ymax);
            }
            catch (InvalidFontException e) {
                throw new PDFIOException(e);
            }
            catch (UnsupportedFontException e) {
                throw new PDFIOException(e);
            }
        }
        return cosfontBBox;
    }

    @Override
    public char[] getUnicode(long charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFToUnicodeCMap toUnicodeCMap = this.getToUnicodeCMap();
        char[] unicodeChar = new char[]{'\ufffd'};
        if (toUnicodeCMap != null) {
            unicodeChar = toUnicodeCMap.toUnicode((int)charCode);
        }
        if (unicodeChar[0] == '\ufffd') {
            PDFSimpleFontEncoding fontEncoding = this.getEncoding();
            if (fontEncoding != null) {
                unicodeChar = fontEncoding.toUnicode((byte)charCode, this.getBaseFont());
            }
            if (unicodeChar[0] == '\ufffd') {
                StandardEncoding stdEncoding = StandardEncoding.getEncoding();
                unicodeChar = stdEncoding.toUnicode((byte)charCode);
            }
        }
        return unicodeChar;
    }

    public int getCharCode(String glyphName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSimpleFontEncoding fontEncoding = this.getEncoding();
        if (fontEncoding != null) {
            return fontEncoding.fromGlyphName(glyphName, StandardFontUtils.getStandardFontProperName(this.getBaseFont()));
        }
        StandardEncoding stdEncoding = StandardEncoding.getEncoding();
        return stdEncoding.fromGlyphName(glyphName);
    }

    public int getCharCode(char unicodeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFToUnicodeCMap toUnicodeCMap = this.getToUnicodeCMap();
        int charcode = -1;
        if (toUnicodeCMap != null) {
            charcode = toUnicodeCMap.fromUnicode(unicodeChar);
        }
        if (charcode != -1) {
            return charcode;
        }
        PDFSimpleFontEncoding fontEncoding = this.getEncoding();
        if (fontEncoding != null) {
            try {
                charcode = fontEncoding.fromUnicode(unicodeChar, StandardFontUtils.getStandardFontProperName(this.getBaseFont()));
                return charcode;
            }
            catch (PDFInvalidDocumentException e) {
                // empty catch block
            }
        }
        StandardEncoding stdEncoding = StandardEncoding.getEncoding();
        return stdEncoding.fromUnicode(unicodeChar);
    }

    @Override
    public byte[] getSpaceCharCode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.spaceCharCode == -1) {
            this.spaceCharCode = this.getCharCode(' ');
        }
        return PDFCMapUtils.numToByteArray(this.spaceCharCode, 2);
    }

    @Override
    public List getCharCodes(byte[] bytes, boolean fetchUnicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList charCodes = new ArrayList();
        for (int i = 0; i < bytes.length; ++i) {
            ArrayList<int[]> charCodeWithUnicode = new ArrayList<int[]>(2);
            charCodeWithUnicode.add(new byte[]{bytes[i]});
            if (fetchUnicode) {
                char[] unicodeChars = this.getUnicode(PDFCMapUtils.getCharCode(new byte[]{bytes[i]}));
                int[] unicodes = new int[unicodeChars.length];
                for (int iUnicode = 0; iUnicode < unicodeChars.length; ++iUnicode) {
                    unicodes[iUnicode] = Character.codePointAt(unicodeChars, iUnicode);
                }
                charCodeWithUnicode.add(unicodes);
            }
            charCodes.add(charCodeWithUnicode);
        }
        return charCodes;
    }

    public List getCharCodes(byte[] bytes, boolean fetchUnicode, Map<Long, int[]> charCodeUnicodeMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList charCodes = new ArrayList();
        for (int i = 0; i < bytes.length; ++i) {
            ArrayList<int[]> charCodeWithUnicode = new ArrayList<int[]>(2);
            charCodeWithUnicode.add(new byte[]{bytes[i]});
            if (fetchUnicode) {
                long charCode = PDFCMapUtils.getCharCode(new byte[]{bytes[i]});
                int[] cachedUnicodes = charCodeUnicodeMap.get(charCode);
                if (cachedUnicodes == null) {
                    char[] unicodeChars = this.getUnicode(PDFCMapUtils.getCharCode(new byte[]{bytes[i]}));
                    int[] unicodes = new int[unicodeChars.length];
                    for (int iUnicode = 0; iUnicode < unicodeChars.length; ++iUnicode) {
                        unicodes[iUnicode] = Character.codePointAt(unicodeChars, iUnicode);
                    }
                    cachedUnicodes = unicodes;
                    charCodeUnicodeMap.put(charCode, cachedUnicodes);
                }
                charCodeWithUnicode.add(cachedUnicodes);
            }
            charCodes.add(charCodeWithUnicode);
        }
        return charCodes;
    }

    private boolean isEmbedded() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontFile file;
        if (this instanceof PDFFontType3) {
            return true;
        }
        PDFFontDescriptor fdesc = this.getFontDescriptor();
        return fdesc != null && (file = PDFFontUtils.getFontFileFromFontDescriptor(fdesc)) != null;
    }

    public static PDFFontDescriptor getStandardFontFontDescriptor(ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            return PDFFontDescriptor.newInstance(StandardFontUtils.getStandardFontProperName(fontName));
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public String charCode2glyphName(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        String glyphName = null;
        try {
            glyphName = PDFFontUtils.charCode2glyphName(charCode, this, this.getAFEFontData());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return glyphName;
    }

    private int charCode2gid(int charCode, FontData fontData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        return PDFFontUtils.getSimpleFontGidFromCharCode(charCode, this.charCode2glyphName(charCode), this.getEncoding(), fontData, this.getFontDescriptor());
    }

    @Override
    public int charCode2gid(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        FontData fontData = this.getAFEFontData();
        if (fontData == null) {
            return 0;
        }
        return this.charCode2gid(charCode, fontData);
    }

    public int charCode2CodePoint(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        return PDFFontUtils.charCode2CodePoint(charCode, this);
    }
}

