/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCharProcs;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import java.util.Iterator;

public class PDFFontType3
extends PDFFontSimple {
    private PDFFontType3(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFFontType3(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
    }

    static PDFFontType3 getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFontType3 pdfObject = (PDFFontType3)PDFCosObject.getCachedInstance(cosObject, PDFFontType3.class);
        if (pdfObject == null) {
            pdfObject = new PDFFontType3(cosObject);
        }
        return pdfObject;
    }

    public static PDFFontType3 newInstance(PDFDocument pdfDocument, ASName baseFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontType3 pdfObject = new PDFFontType3(pdfDocument);
        pdfObject.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Type3);
        pdfObject.setBaseFont(baseFont);
        return pdfObject;
    }

    @Override
    public String toString() {
        return "Type3 Font";
    }

    @Override
    public ASName getBaseFont() {
        return null;
    }

    public PDFRectangle getFontBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRectangle.getInstance(this.getCosDictionary().get(ASName.k_FontBBox));
    }

    public ASMatrix getFontMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] values = new double[6];
        CosArray array = this.getCosDictionary().getCosArray(ASName.k_FontMatrix);
        Iterator<CosObject> iter = array.iterator();
        int i = 0;
        while (iter.hasNext()) {
            values[i++] = iter.next().doubleValue();
        }
        return new ASMatrix(values);
    }

    public PDFCharProcs getCharProcs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCharProcs.getInstance(this.getCosDictionary().getCosDictionary(ASName.k_CharProcs));
    }

    @Override
    public PDFSimpleFontEncoding getEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSimpleFontEncoding encoding = super.getEncoding();
        if (encoding != null) {
            return encoding;
        }
        throw new PDFInvalidDocumentException("Type3 font dictionary missing required encoding entry");
    }

    public PDFResources getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_Resources)) {
            return PDFResources.getInstance(this.getCosDictionary().getCosDictionary(ASName.k_Resources));
        }
        return null;
    }

    public void setResources(PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Resources, resources);
    }

    @Override
    public double getAscent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontDescriptor fd = this.getFontDescriptor();
        if (fd != null && fd.containsAscent()) {
            return fd.getAscent();
        }
        return this.getFontBBox().top();
    }

    @Override
    public double getDescent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontDescriptor fd = this.getFontDescriptor();
        if (fd != null && fd.containsDescent()) {
            return fd.getDescent();
        }
        return this.getFontBBox().bottom();
    }

    @Override
    public ASRectangle getBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            return new ASRectangle(this.getFontBBox().getValues());
        }
        catch (PDFInvalidParameterException e) {
            throw new RuntimeException("Internal programming error.", e);
        }
    }
}

