/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFEncodingDifferences;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.CharSetEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.Encoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.StandardCharSetEncodings;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.AdobeGlyphList;
import java.util.Map;

public class PDFSimpleFontEncoding
extends PDFCosObject
implements Encoding {
    private PDFSimpleFontEncoding(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    static PDFSimpleFontEncoding getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSimpleFontEncoding pdfObject = (PDFSimpleFontEncoding)PDFCosObject.getCachedInstance(cosObject, PDFSimpleFontEncoding.class);
        if (pdfObject == null) {
            pdfObject = new PDFSimpleFontEncoding(cosObject);
        }
        return pdfObject;
    }

    public static PDFSimpleFontEncoding newInstance(PDFDocument pdfDocument, CharSetEncoding encoding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFSimpleFontEncoding pdfObject = new PDFSimpleFontEncoding(cosObject);
        cosObject.put(ASName.k_Type, ASName.k_Encoding);
        if (encoding != null) {
            cosObject.put(ASName.k_BaseEncoding, encoding.getName());
        }
        return pdfObject;
    }

    public static PDFSimpleFontEncoding newInstance(PDFDocument pdfDocument, ASName encoding) throws PDFInvalidDocumentException {
        CosName cosObject = PDFCosObject.newCosName(pdfDocument, encoding);
        return new PDFSimpleFontEncoding(cosObject);
    }

    public static PDFSimpleFontEncoding newInstance(PDFDocument pdfDocument, CharSetEncoding encoding, Map<Integer, String> differences) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSimpleFontEncoding simpleFontEncoding = PDFSimpleFontEncoding.newInstance(pdfDocument, encoding);
        if (differences != null && !differences.isEmpty()) {
            PDFEncodingDifferences pdfEncodingDifferences = PDFEncodingDifferences.newInstance(pdfDocument, differences);
            simpleFontEncoding.setDifferences(pdfEncodingDifferences);
        }
        return simpleFontEncoding;
    }

    public CharSetEncoding getBaseEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosObject() instanceof CosName) {
            try {
                return StandardCharSetEncodings.get(((CosName)this.getCosObject()).nameValue());
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Could not get a pre-defined character set encoding", e);
            }
        }
        if (this.getCosObject() instanceof CosDictionary) {
            try {
                if (((CosDictionary)this.getCosObject()).containsKey(ASName.k_BaseEncoding)) {
                    ASName baseName = ((CosDictionary)this.getCosObject()).getName(ASName.k_BaseEncoding);
                    return StandardCharSetEncodings.get(baseName);
                }
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Could not get a pre-defined character set encoding", e);
            }
        }
        return null;
    }

    CharSetEncoding getBaseEncoding(boolean isSymbolic, boolean isEmbedded) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding retVal = this.getBaseEncoding();
        if (retVal != null) {
            return retVal;
        }
        if (!isSymbolic && !isEmbedded) {
            try {
                return StandardCharSetEncodings.get(ASName.k_StandardEncoding);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Could not get a pre-defined character set encoding", e);
            }
        }
        return null;
    }

    public CharSetEncoding getBaseEncoding(ASName fontName, boolean isEmbedded) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding retVal = this.getBaseEncoding();
        if (retVal != null) {
            return retVal;
        }
        if (!isEmbedded) {
            return StandardCharSetEncodings.getDefaultCharsetForFont(fontName);
        }
        return null;
    }

    public CharSetEncoding getBaseEncoding(ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getBaseEncoding(fontName, false);
    }

    public PDFEncodingDifferences getDifferences() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEncodingDifferences diffs = null;
        if (this.getCosObject() instanceof CosDictionary) {
            if (((CosDictionary)this.getCosObject()).containsKey(ASName.k_Differences)) {
                CosArray array = ((CosDictionary)this.getCosObject()).getCosArray(ASName.k_Differences);
                return PDFEncodingDifferences.getInstance(array);
            }
            return null;
        }
        return diffs;
    }

    public void setDifferences(PDFEncodingDifferences diffs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ((CosDictionary)this.getCosObject()).put(ASName.k_Differences, diffs.getCosArray());
    }

    @Override
    public String toUnicode(ASString string) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        byte[] bytes = string.getBytes();
        return this.toUnicode(bytes, 0, bytes.length);
    }

    public String toUnicode(ASString string, ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        byte[] bytes = string.getBytes();
        return this.toUnicode(bytes, 0, bytes.length, fontName);
    }

    @Override
    public String toUnicode(byte[] bytes, int start, int length) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEnc = this.getBaseEncoding();
        return this.toUnicode(bytes, start, length, baseEnc);
    }

    public String toUnicode(byte[] bytes, int start, int length, ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEnc = this.getBaseEncoding(fontName);
        return this.toUnicode(bytes, start, length, baseEnc);
    }

    private String toUnicode(byte[] bytes, int start, int length, CharSetEncoding baseEnc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEncodingDifferences diffs = this.getDifferences();
        if (baseEnc == null) {
            try {
                baseEnc = StandardCharSetEncodings.get(ASName.k_StandardEncoding);
            }
            catch (PDFInvalidParameterException e) {
                throw new RuntimeException("Could not get a pre-defined character set encoding", e);
            }
        }
        if (length > 0 && bytes != null) {
            StringBuilder strBuf = new StringBuilder(bytes.length);
            for (int i = start; i < length; ++i) {
                char[] uniChars = new char[1];
                int charCode = bytes[i] & 0xFF;
                if (diffs != null && diffs.contains(charCode)) {
                    uniChars = diffs.toUnicode(charCode);
                } else if (baseEnc != null) {
                    uniChars = baseEnc.toUnicode(bytes[i]);
                } else {
                    uniChars[0] = 65533;
                }
                strBuf.append(uniChars);
            }
            return strBuf.toString();
        }
        return null;
    }

    @Override
    public char[] toUnicode(byte charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEnc = this.getBaseEncoding();
        return this.toUnicode(charCode, baseEnc);
    }

    @Override
    public char[] toUnicode(byte charCode, ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEnc = this.getBaseEncoding(fontName);
        return this.toUnicode(charCode, baseEnc);
    }

    private char[] toUnicode(byte charCode, CharSetEncoding baseEnc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEncodingDifferences diffs = this.getDifferences();
        char[] unicodes = new char[]{'\ufffd'};
        int index = charCode & 0xFF;
        if (diffs != null && diffs.contains(index)) {
            unicodes = diffs.toUnicode(index);
        } else if (baseEnc != null) {
            unicodes = baseEnc.toUnicode(charCode);
        } else {
            unicodes[0] = 65533;
        }
        return unicodes;
    }

    @Override
    public int fromUnicode(char unicodeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEnc = this.getBaseEncoding();
        return this.fromUnicode(unicodeChar, baseEnc);
    }

    public int fromGlyphName(ASString glyphName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEnc = this.getBaseEncoding();
        return this.fromGlyphName(glyphName.asString(), baseEnc);
    }

    public int fromGlyphName(String glyphName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEnc = this.getBaseEncoding();
        return this.fromGlyphName(glyphName, baseEnc);
    }

    public int fromGlyphName(String glyphName, ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEnc = this.getBaseEncoding(fontName);
        return this.fromGlyphName(glyphName, baseEnc);
    }

    int fromUnicode(char unicodeChar, ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEnc = this.getBaseEncoding(fontName);
        return this.fromUnicode(unicodeChar, baseEnc);
    }

    private int fromUnicode(char unicodeChar, CharSetEncoding baseEnc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        AdobeGlyphList glyphList;
        ASName[] glyphNames;
        PDFEncodingDifferences diffs = this.getDifferences();
        boolean found = false;
        int charCode = 0;
        if (diffs != null && (glyphNames = (glyphList = AdobeGlyphList.get()).fromUnicode(unicodeChar)).length > 0 && diffs.contains(glyphNames[0])) {
            charCode = diffs.fromGlyphName(glyphNames[0]);
            found = true;
        }
        if (!found) {
            if (baseEnc == null) {
                try {
                    baseEnc = StandardCharSetEncodings.get(ASName.k_StandardEncoding);
                }
                catch (PDFInvalidParameterException e) {
                    throw new RuntimeException("Could not get a pre-defined character set encoding", e);
                }
            }
            charCode = baseEnc.fromUnicode(unicodeChar);
        }
        return charCode;
    }

    private int fromGlyphName(String glyphName, CharSetEncoding baseEnc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEncodingDifferences diffs = this.getDifferences();
        boolean found = false;
        int charCode = 0;
        ASName name = ASName.create(glyphName);
        if (diffs != null && diffs.contains(name)) {
            charCode = diffs.fromGlyphName(name);
            found = true;
        }
        if (!found) {
            if (baseEnc == null) {
                try {
                    baseEnc = StandardCharSetEncodings.get(ASName.k_StandardEncoding);
                }
                catch (PDFInvalidParameterException e) {
                    throw new RuntimeException("Could not get a pre-defined character set encoding", e);
                }
            }
            charCode = baseEnc.fromGlyphName(glyphName);
            if (diffs != null && charCode != 0 && diffs.contains(charCode)) {
                charCode = 0;
            }
        }
        return charCode;
    }

    @Override
    public String getGlyphName(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name;
        PDFEncodingDifferences diffs = this.getDifferences();
        if (diffs != null && (name = diffs.toGlyphName(charCode)) != null) {
            return name.asString(true);
        }
        CharSetEncoding encoding = this.getBaseEncoding();
        if (encoding != null) {
            return encoding.getGlyphName(charCode);
        }
        return null;
    }

    public String getGlyphName(int charCode, boolean isSymbolic, boolean isEmbedded) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name;
        PDFEncodingDifferences diffs = this.getDifferences();
        if (diffs != null && (name = diffs.toGlyphName(charCode)) != null) {
            return name.asString(true);
        }
        CharSetEncoding encoding = this.getBaseEncoding(isSymbolic, isEmbedded);
        if (encoding != null) {
            return encoding.getGlyphName(charCode);
        }
        return null;
    }

    public String getGlyphName(int charCode, ASName fontName, boolean isEmbedded) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String name;
        PDFEncodingDifferences diffs = this.getDifferences();
        if (diffs != null && diffs.contains(charCode) && (name = diffs.toGlyphName(charCode).asString(true)) != null) {
            return name;
        }
        CharSetEncoding encoding = this.getBaseEncoding(fontName, isEmbedded);
        if (encoding != null) {
            return encoding.getGlyphName(charCode);
        }
        return null;
    }

    public String getGlyphName(int charCode, ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getGlyphName(charCode, fontName, false);
    }

    public ASName getGlyphNameAsASName(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name;
        PDFEncodingDifferences diffs = this.getDifferences();
        if (diffs != null && (name = diffs.toGlyphName(charCode)) != null) {
            return name;
        }
        CharSetEncoding encoding = this.getBaseEncoding();
        if (encoding != null) {
            return ASName.create(encoding.getGlyphName(charCode));
        }
        return null;
    }

    public ASName getGlyphNameAsASName(int charCode, boolean isSymbolic, boolean isEmbedded) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name;
        PDFEncodingDifferences diffs = this.getDifferences();
        if (diffs != null && (name = diffs.toGlyphName(charCode)) != null) {
            return name;
        }
        CharSetEncoding encoding = this.getBaseEncoding(isSymbolic, isEmbedded);
        if (encoding != null) {
            return ASName.create(encoding.getGlyphName(charCode));
        }
        return null;
    }

    public boolean isMacRomanEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEncoding;
        return this.getCosObject() instanceof CosName ? ASName.k_MacRomanEncoding.equals(((CosName)this.getCosObject()).nameValue()) : (baseEncoding = this.getBaseEncoding()) != null && this.getDifferences() == null && ASName.k_MacRomanEncoding.equals(baseEncoding.getName());
    }

    public boolean isMacExpertEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEncoding;
        return this.getCosObject() instanceof CosName ? ASName.k_MacExpertEncoding.equals(((CosName)this.getCosObject()).nameValue()) : (baseEncoding = this.getBaseEncoding()) != null && this.getDifferences() == null && ASName.k_MacExpertEncoding.equals(baseEncoding.getName());
    }

    public boolean isWinAnsiEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharSetEncoding baseEncoding;
        return this.getCosObject() instanceof CosName ? ASName.k_WinAnsiEncoding.equals(((CosName)this.getCosObject()).nameValue()) : (baseEncoding = this.getBaseEncoding()) != null && this.getDifferences() == null && ASName.k_WinAnsiEncoding.equals(baseEncoding.getName());
    }
}

