/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font.impl;

import com.adobe.fontengine.FontEngineException;
import com.adobe.internal.io.ByteReaderWrapperImpl;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.LazyRandomAccessFileByteReader;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CMapObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapCodesSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapObjectCache;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapResourceBuilder;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapsUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

public class CMapObjectImpl
implements CMapObject,
Serializable {
    static final long serialVersionUID = 1L;
    static final String[] cidToUnicodeMapNames = new String[]{"Adobe-CNS1-UCS2", "Adobe-GB1-UCS2", "Adobe-Japan1-UCS2", "Adobe-Korea1-UCS2"};
    static HashMap<Long, Integer> spaceCharMap;
    static CMapResourceBuilder builder;
    static CMapObject[] cidToUnicodeCMaps;
    static final boolean usePrebuiltCMaps = false;
    String registry;
    String ordering;
    int supplement;
    String writingMode;
    String name;
    String baseName;
    CMapCodesSpace[] codesSpaces;
    int minBytesNeeded = 0;
    int maxBytesAllowed = 0;
    HashMap<Long, Integer> spaceCharCodeMap;
    HashMap<Long, Integer> charCodeCIDMap = null;
    HashMap<Long, int[]> charCodeCIDMapLong = null;

    CMapObjectImpl(String registry2, String ordering2, int supplement2, String writingMode2, String cmapName, String useCMapName, CMapCodesSpace[] codesSpaces2, int minBytes, int maxBytes, HashMap<Long, Integer> spaceCharacterCodeToUnicodeMap, HashMap<Long, Integer> charCodeCIDMap2, HashMap<Long, int[]> charCodeToCIDMapLong2) {
        this.registry = registry2;
        this.ordering = ordering2;
        this.supplement = supplement2;
        this.writingMode = writingMode2;
        this.name = cmapName;
        this.baseName = useCMapName;
        this.codesSpaces = codesSpaces2;
        this.minBytesNeeded = minBytes;
        this.maxBytesAllowed = maxBytes;
        this.spaceCharCodeMap = spaceCharacterCodeToUnicodeMap;
        this.charCodeCIDMap = charCodeCIDMap2;
        this.charCodeCIDMapLong = charCodeToCIDMapLong2;
    }

    @Override
    public int[] getValue(long code) {
        int[] values = null;
        if (this.baseName != null) {
            if (code <= Integer.MAX_VALUE && !this.charCodeCIDMap.isEmpty() && this.charCodeCIDMap.containsKey(code)) {
                return new int[]{this.charCodeCIDMap.get(code)};
            }
            if (!this.charCodeCIDMapLong.isEmpty() && this.charCodeCIDMapLong.containsKey(code)) {
                return this.charCodeCIDMapLong.get(code);
            }
        }
        for (int iCodeSpace = 0; iCodeSpace < this.codesSpaces.length; ++iCodeSpace) {
            CMapCodesSpace codeSpace = this.codesSpaces[iCodeSpace];
            if (!codeSpace.isCodeInCodeSpace(code)) continue;
            values = codeSpace.getCodeValue(code);
        }
        return values;
    }

    @Override
    public void enumerateValues(CMapObject.CMapValueConsumer consumer) throws FontEngineException {
        for (int iCodeSpace = 0; iCodeSpace < this.codesSpaces.length; ++iCodeSpace) {
            CMapCodesSpace codeSpace = this.codesSpaces[iCodeSpace];
            codeSpace.enumerateValues(consumer);
        }
    }

    public static synchronized CMapObject get(String cmapName) throws MissingResourceException {
        CMapObject cmapObj = null;
        ObjectInputStream objectInputStream = null;
        try {
            int i;
            if (builder == null) {
                builder = CMapResourceBuilder.getInstance();
                spaceCharMap = new HashMap();
                cidToUnicodeCMaps = new CMapObject[cidToUnicodeMapNames.length];
                for (i = 0; i < cidToUnicodeMapNames.length; ++i) {
                    CMapObjectImpl.cidToUnicodeCMaps[i] = builder.parseCMapFile(cidToUnicodeMapNames[i], false, spaceCharMap, false);
                }
            }
            if (cmapName.startsWith("Adobe-")) {
                for (i = 0; i < cidToUnicodeMapNames.length; ++i) {
                    if (!cmapName.equals(cidToUnicodeMapNames[i])) continue;
                    CMapObject cMapObject = cidToUnicodeCMaps[i];
                    return cMapObject;
                }
            }
            cmapObj = builder.parseCMapFile(cmapName, false, spaceCharMap, false);
        }
        catch (Exception e) {
            MissingResourceException ee = new MissingResourceException("", "", "");
            ee.initCause(e);
            throw ee;
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return cmapObj;
    }

    public static synchronized CMapObject get(InputStream cmapStream, Map<String, InputStream> useCMaps) throws MissingResourceException {
        CMapObject cmapObj = null;
        BufferedReader lnr = null;
        try {
            if (builder == null) {
                builder = CMapResourceBuilder.getInstance();
                spaceCharMap = new HashMap();
                cidToUnicodeCMaps = new CMapObject[cidToUnicodeMapNames.length];
                for (int i = 0; i < cidToUnicodeMapNames.length; ++i) {
                    CMapObjectImpl.cidToUnicodeCMaps[i] = builder.parseCMapFile(cidToUnicodeMapNames[i], false, spaceCharMap, false);
                }
            }
            cmapObj = builder.parseCMapFile(new LineNumberReader(new InputStreamReader(cmapStream)), useCMaps, false, spaceCharMap, false);
        }
        catch (Exception e) {
            MissingResourceException ee = new MissingResourceException("", "", "");
            ee.initCause(e);
            throw ee;
        }
        finally {
            if (cmapStream != null) {
                try {
                    cmapStream.close();
                }
                catch (IOException e) {}
            }
            if (lnr != null) {
                try {
                    lnr.close();
                }
                catch (IOException e) {}
            }
        }
        return cmapObj;
    }

    @Override
    public String getRegistry() {
        return this.registry;
    }

    @Override
    public String getOrdering() {
        return this.ordering;
    }

    @Override
    public int getSupplement() {
        return this.supplement;
    }

    @Override
    public String getWritingMode() {
        return this.writingMode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public void setWritingMode(String writingMode) {
        this.writingMode = writingMode;
    }

    @Override
    public CMapCodesSpace[] getCodesSpaces() {
        return this.codesSpaces;
    }

    @Override
    public int getMaxBytesAllowed() {
        return this.maxBytesAllowed;
    }

    @Override
    public int getMinBytesNeeded() {
        return this.minBytesNeeded;
    }

    @Override
    public HashMap<Long, Integer> getSpaceCharCodeMap() {
        return this.spaceCharCodeMap;
    }

    @Override
    public boolean hasPrebuiltCMaps() {
        return false;
    }

    @Override
    public CosStream getCMapStream(CosDocument cosDoc, boolean allowUseCmapEntry) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosStream cmapObj = cosDoc.createCosStream();
        try {
            cmapObj.put(ASName.k_Type, ASName.k_CMap);
            cmapObj.put(ASName.k_CMapName, this.getName());
            CosDictionary sysInfo = cosDoc.createDirectCosDictionary();
            sysInfo.put(ASName.k_Registry, new ASString(this.getRegistry()));
            sysInfo.put(ASName.k_Ordering, new ASString(this.getOrdering()));
            sysInfo.put(ASName.k_Supplement, this.getSupplement());
            cmapObj.put(ASName.k_CIDSystemInfo, sysInfo);
            String wMode = this.getWritingMode();
            cmapObj.put(ASName.k_WMode, "1".equals(wMode) ? 1 : 0);
            String baseCMap = this.getBaseName();
            if (baseCMap != null) {
                if (allowUseCmapEntry) {
                    if ("Identity_H".equals(baseCMap)) {
                        cmapObj.put(ASName.k_UseCMap, ASName.k_Identity_H);
                    } else if ("Identity_V".equals(baseCMap)) {
                        cmapObj.put(ASName.k_UseCMap, ASName.k_Identity_V);
                    } else {
                        CMapObject baseCmap = PDFCMap.getCMapObjectForName(baseCMap);
                        cmapObj.put(ASName.k_UseCMap, baseCmap.getCMapStream(cosDoc, allowUseCmapEntry));
                    }
                } else if (CMapsUtil.isPredefinedCmapPermitted(baseCMap)) {
                    cmapObj.put(ASName.k_UseCMap, ASName.create(baseCMap));
                } else {
                    return null;
                }
            }
            ByteReaderWrapperImpl reader = null;
            if (this.hasPrebuiltCMaps()) {
                File cmapfile = new File("resources/cmaps/" + this.name);
                reader = new LazyRandomAccessFileByteReader(cmapfile);
            } else {
                OutputByteStream cmapTempStream = cosDoc.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, 1024L);
                InputByteStream cmapStream = CMapObjectCache.getInputStreamForCmap(this.getName(), cmapTempStream);
                reader = new InputStreamByteReader(cmapStream.toInputStream());
            }
            InputByteStream data = cosDoc.getStreamManager().getInputByteStream(reader);
            cmapObj.newDataDecoded(data);
            cmapObj.put(ASName.k_Filter, ASName.k_FlateDecode);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return cmapObj;
    }
}

