/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PDFOCGroupList
extends PDFCosObject {
    private static final int ARRAY = 1;
    private static final int DICTIONARY = 2;
    private final int mType;

    private PDFOCGroupList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
        if (cosObject instanceof CosArray) {
            this.mType = 1;
        } else if (cosObject instanceof CosDictionary) {
            this.mType = 2;
        } else {
            throw new PDFInvalidDocumentException("Array or dictionary expected");
        }
    }

    public static PDFOCGroupList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCGroupList pdfObject = (PDFOCGroupList)PDFCosObject.getCachedInstance(cosObject, PDFOCGroupList.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCGroupList(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCGroupList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFOCGroupList(cosObject);
    }

    public static PDFOCGroupList newInstance(PDFDocument pdfDocument, PDFOCGroup ocg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFOCGroupList pdfObject = PDFOCGroupList.newInstance(pdfDocument);
        pdfObject.add(ocg);
        return pdfObject;
    }

    public Iterator iterator() throws PDFInvalidDocumentException {
        if (this.mType == 1) {
            return this.getOCGroupArray().iterator();
        }
        return new OCGSingleIterator();
    }

    public boolean contains(PDFOCGroup ocg) throws PDFInvalidDocumentException {
        if (this.mType == 1) {
            return this.getOCGroupArray().contains(ocg);
        }
        return this.getSingleOCGroup() == ocg;
    }

    public PDFOCGroup getOCGByName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroup result = null;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            String ocgName;
            PDFOCGroup ocg = (PDFOCGroup)iter.next();
            if (ocg == null || !(ocgName = ocg.getName()).equals(name)) continue;
            result = ocg;
            break;
        }
        return result;
    }

    public PDFOCGroupArray getOCGroupArray() throws PDFInvalidDocumentException {
        if (this.mType == 1) {
            return PDFOCGroupArray.getInstance(this.getCosObject());
        }
        return null;
    }

    public PDFOCGroup getSingleOCGroup() {
        if (this.mType == 2) {
            try {
                return PDFOCGroup.getInstance(this.getCosObject());
            }
            catch (PDFInvalidDocumentException e) {
                return null;
            }
        }
        return null;
    }

    public void add(PDFOCGroup ocg) throws PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFInvalidDocumentException {
        if (this.mType != 1) {
            throw new PDFInvalidParameterException("Illegal attempt to add an OCG to an OCG dictionary rather than an OCG array.");
        }
        this.getOCGroupArray().add(ocg);
    }

    public boolean isEmpty() throws PDFInvalidDocumentException {
        if (this.mType == 1) {
            return this.getOCGroupArray().isEmpty();
        }
        return false;
    }

    public int size() throws PDFInvalidDocumentException {
        if (this.mType == 1) {
            return this.getOCGroupArray().size();
        }
        return 1;
    }

    class OCGSingleIterator
    implements Iterator {
        private CosObject mNextObj = null;

        OCGSingleIterator() {
            this.mNextObj = PDFOCGroupList.this.getCosObject();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public boolean hasNext() {
            return this.mNextObj != null;
        }

        public Object next() {
            CosObject obj = this.mNextObj;
            if (obj == null) {
                throw new NoSuchElementException();
            }
            this.mNextObj = null;
            try {
                return PDFOCGroup.getInstance(obj);
            }
            catch (PDFInvalidDocumentException e) {
                return null;
            }
        }
    }
}

