/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCVExpression;

public class PDFOCMembership
extends PDFOCObject {
    protected PDFOCMembership(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCMembership getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCMembership pdfObject = (PDFOCMembership)PDFCosObject.getCachedInstance(cosObject, PDFOCMembership.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCMembership(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCMembership newInstance(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCMembership ocmd = new PDFOCMembership(PDFCosObject.newCosDictionary(pdfDoc));
        ocmd.setDictionaryNameValue(ASName.k_Type, ASName.k_OCMD);
        ocmd.setOCGS(PDFOCGroupList.newInstance(pdfDoc));
        ocmd.setVisibilityPolicyAnyOn();
        return ocmd;
    }

    @Override
    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public PDFOCGroupList getOCGs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupList result = null;
        CosObject ocgObj = this.getDictionaryCosObjectValue(ASName.k_OCGs);
        result = PDFOCGroupList.getInstance(ocgObj);
        return result;
    }

    public void addOCG(PDFOCGroup ocg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosObject ocgsObj;
        PDFOCGroupList ocgs = this.getOCGs();
        if (ocgs == null) {
            ocgs = PDFOCGroupList.newInstance(this.getPDFDocument());
        }
        if ((ocgsObj = ocgs.getCosObject()) instanceof CosDictionary) {
            PDFOCGroup myOCG = PDFOCGroup.getInstance(ocgsObj);
            PDFOCGroupList newOcgs = PDFOCGroupList.newInstance(this.getPDFDocument(), myOCG);
            CosArray newOcgsObj = newOcgs.getCosArray();
            this.setOCGS(newOcgs);
            ocgs = newOcgs;
            ocgsObj = newOcgsObj;
        }
        if (ocgsObj instanceof CosArray && !ocgs.contains(ocg)) {
            ((CosArray)ocgsObj).add(ocg.getCosObject());
        }
    }

    public void setOCGS(PDFOCGroupList ocgs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_OCGs, ocgs);
    }

    public void setOCGS(PDFOCGroup ocgs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_OCGs, ocgs);
    }

    public void setVisibilityPolicyAllOn() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setVisibilityPolicy(ASName.k_AllOn);
    }

    public void setVisibilityPolicyAllOff() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setVisibilityPolicy(ASName.k_AllOff);
    }

    public void setVisibilityPolicyAnyOn() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setVisibilityPolicy(ASName.k_AnyOn);
    }

    public void setVisibilityPolicyAnyOff() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setVisibilityPolicy(ASName.k_AnyOff);
    }

    private void setVisibilityPolicy(ASName policy) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_P, policy);
    }

    public ASName getVisibilityPolicy() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName vp = this.getDictionaryNameValue(ASName.k_P);
        return vp != null ? vp : ASName.k_AnyOn;
    }

    public boolean hasVisibilityExpression() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_VE);
    }

    public void setVisibilityExpression(PDFOCVExpression exp) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray expArray = exp.getCosArray();
        this.setDictionaryArrayValue(ASName.k_VE, expArray);
    }

    public PDFOCVExpression getVisibilityExpression() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCVExpression result = null;
        CosArray obj = this.getDictionaryArrayValue(ASName.k_VE);
        if (obj != null) {
            result = PDFOCVExpression.getInstance(obj);
        }
        return result;
    }
}

