/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.patterns;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingFactory;

public class PDFPatternShading
extends PDFCosDictionary
implements PDFPattern {
    private PDFPatternShading(CosObject cosStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosStream);
    }

    private PDFPatternShading(PDFDocument pdfDocument, PDFShading shading) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(PDFCosObject.newCosDictionary(pdfDocument));
        this.setShading(shading);
        this.setDictionaryIntValue(ASName.k_PatternType, 2L);
    }

    public static PDFPatternShading newInstance(PDFDocument pdfDocument, PDFShading key_Shading) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Shading == null) {
            throw new PDFInvalidDocumentException("Shading is required when creating newInstance of PDFPatternShading.");
        }
        return new PDFPatternShading(pdfDocument, key_Shading);
    }

    public static PDFPatternShading getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPatternShading pdfObject = (PDFPatternShading)PDFCosObject.getCachedInstance(cosObject, PDFPatternShading.class);
        if (pdfObject == null) {
            pdfObject = new PDFPatternShading(cosObject);
        }
        return pdfObject;
    }

    @Override
    public int getPatternType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_PatternType);
    }

    public PDFExtGState getExtGState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFExtGState.getInstance(this.getDictionaryCosObjectValue(ASName.k_ExtGState));
    }

    public void setExtGState(PDFExtGState value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_ExtGState, value);
    }

    public boolean hasExtGState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ExtGState);
    }

    public CosArray getMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (CosArray)this.getDictionaryValue(ASName.k_Matrix);
    }

    public void setMatrix(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Matrix, value);
    }

    public boolean hasMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Matrix);
    }

    public PDFShading getShading() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            return PDFShadingFactory.getInstance(this.getDictionaryCosObjectValue(ASName.k_Shading));
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public void setShading(PDFShading value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Shading is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Shading, value.getPDFCosObject());
    }

    public void setShading(CosStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Shading is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Shading, value);
    }

    public boolean hasShading() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Shading);
    }

    @Override
    public PDFCosDictionary getPDFCosObject() {
        return this;
    }
}

