/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.xobject;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectAltImageList;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImageMask;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectUtil;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMeasure;
import com.adobe.internal.pdftoolkit.pdf.interactive.geospatial.PDFPointData;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOPIVersion;
import com.adobe.internal.pdftoolkit.pdf.transparency.PDFXObjectImageSoftMask;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class PDFXObjectImage
extends PDFXObject {
    protected static final ASName k_Image = ASName.create("Image");

    protected PDFXObjectImage(CosObject cosStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosStream);
    }

    public static PDFXObjectImage getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFXObjectImage pdfObject = (PDFXObjectImage)PDFCosObject.getCachedInstance(cosObject, PDFXObjectImage.class);
        if (pdfObject == null) {
            pdfObject = new PDFXObjectImage(cosObject);
        }
        return pdfObject;
    }

    public static PDFXObjectImage newInstance(PDFDocument pdfDocument) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosStream cosObject = PDFCosObject.newCosStream(pdfDocument);
        PDFXObjectImage pdfObject = new PDFXObjectImage(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_XObject);
        pdfObject.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Image);
        pdfObject.setType();
        return pdfObject;
    }

    public static PDFXObjectImage newInstance(PDFDocument pdfDocument, int width, int height, PDFColorSpace colorSpace) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        PDFXObjectImage xobj = PDFXObjectImage.newInstance(pdfDocument);
        xobj.setWidth(width);
        xobj.setHeight(height);
        if (colorSpace != null) {
            xobj.setColorSpace(colorSpace);
        }
        xobj.setType();
        xobj.setSubtype(k_Image);
        return xobj;
    }

    public ASName getSubType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Subtype);
    }

    public void setWidth(int width) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Width, width);
    }

    public int getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Width);
    }

    public void setHeight(int height) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Height, height);
    }

    public int getHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Height);
    }

    public void setColorSpace(PDFColorSpace colorSpace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ColorSpace, colorSpace);
    }

    public PDFColorSpace getColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject colorSpaceObj = this.getDictionaryCosObjectValue(ASName.k_ColorSpace);
        return PDFColorSpaceFactory.getInstance(colorSpaceObj);
    }

    public void setBitsPerComponent(int bits) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_BitsPerComponent, bits);
    }

    public int getBitsPerComponent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number value = PDFXObjectUtil.getValidBitsPerComponentValue(this);
        if (value == null) {
            throw new PDFInvalidDocumentException("Image XObject does not contain BitsPerComponent");
        }
        return value.intValue();
    }

    public void setIntent(ASName intent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Intent, intent);
    }

    public ASName getIntent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Intent);
    }

    public void setDecode(double[] decodeArray) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        ArrayList<Double> decodeList = null;
        if (decodeArray != null) {
            decodeList = new ArrayList<Double>(decodeArray.length);
            for (int indx = 0; indx < decodeArray.length; ++indx) {
                decodeList.add(indx, new Double(decodeArray[indx]));
            }
        }
        this.setDictionaryArrayValue(ASName.k_Decode, decodeList);
    }

    public double[] getDecode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName decodeKey = ASName.k_Decode;
        if (!this.dictionaryContains(decodeKey)) {
            return null;
        }
        CosArray decodeList = this.getDictionaryArrayValue(decodeKey);
        double[] result = decodeList.getArrayDouble();
        return result;
    }

    public boolean hasDecodeArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Decode);
    }

    public void setIsInterpolate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName interpolateKey = ASName.k_Interpolate;
        this.setDictionaryBooleanValue(interpolateKey, true);
    }

    public boolean getIsInterpolate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName interpolateKey = ASName.k_Interpolate;
        boolean result = false;
        if (this.dictionaryContains(interpolateKey)) {
            result = this.getDictionaryBooleanValue(interpolateKey);
        }
        return result;
    }

    public void setIsImageMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_ImageMask, true);
    }

    public boolean getIsImageMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean result = false;
        if (this.dictionaryContains(ASName.k_ImageMask)) {
            result = this.getDictionaryBooleanValue(ASName.k_ImageMask);
        }
        return result;
    }

    public void setMask(PDFXObjectImageMask mask) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Mask, mask);
    }

    public PDFXObjectImageMask getMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXObjectImageMask.getInstance(this.getDictionaryCosObjectValue(ASName.k_Mask));
    }

    public boolean hasMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Mask);
    }

    public PDFXObjectImage getSMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXObjectImage.getInstance(this.getDictionaryCosObjectValue(ASName.k_SMask));
    }

    public void setSMask(PDFXObjectImage image) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_SMask, image);
    }

    public PDFXObjectImage getMaskImage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectImageMask mask = this.getMask();
        return mask.getImageMask();
    }

    public void setMaskImage(PDFXObjectImage image) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectImageMask mask = PDFXObjectImageMask.getInstance(image.getCosObject());
        this.setMask(mask);
    }

    public void setAlternatesList(PDFXObjectAltImageList alternates) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Alternates, alternates);
    }

    public PDFXObjectAltImageList getAlternatesList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectAltImageList result = null;
        CosArray obj = this.getDictionaryArrayValue(ASName.k_Alternates);
        if (obj != null) {
            result = PDFXObjectAltImageList.getInstance(obj);
        }
        return result;
    }

    public void setMaskInData(int code) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.create("SMaskInData"), code);
    }

    public int getMaskInData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int result = 0;
        ASName key = ASName.create("SMaskInData");
        if (this.dictionaryContains(key)) {
            result = this.getDictionaryIntValue(key);
        }
        return result;
    }

    public void setID(String id) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryASStringValue(ASName.k_ID, new ASString(id));
    }

    public String getID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString asStr = this.getDictionaryStringValue(ASName.k_ID);
        return asStr != null ? asStr.asString() : null;
    }

    public PDFOPIVersion getOPIVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFOPIVersion.getInstance(this.getDictionaryCosObjectValue(ASName.k_OPI));
    }

    public void setOPIVersion(PDFOPIVersion opiVersion) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_OPI, opiVersion);
    }

    public InputStream getImageStreamData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosStream().getStreamDecodedNoCopying();
    }

    public boolean hasImageStreamData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosStream().getStreamDecoded() != null;
    }

    public boolean getImageStreamData(OutputStream os) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.getCosStream().copyStream(os, false);
    }

    public void setImageStreamData(InputByteStream streamData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosStream().newDataDecoded(streamData);
    }

    public int getPredictor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName decodeKey = ASName.create("DecodeParm");
        if (!this.dictionaryContains(decodeKey)) {
            return 1;
        }
        CosDictionary decodeList = this.getDictionaryDictionaryValue(decodeKey);
        if (decodeList != null) {
            int i = -1;
            i = decodeList.getInt(ASName.create("Predictor"));
            if (i != -1) {
                return i;
            }
        }
        return 1;
    }

    public boolean getBlackIs1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName decodeKey = ASName.create("DecodeParms");
        boolean i = false;
        if (!this.dictionaryContains(decodeKey)) {
            return i;
        }
        CosDictionary decodeList = this.getDictionaryDictionaryValue(decodeKey);
        if (decodeList != null && decodeList.containsKey(ASName.create("BlackIs1"))) {
            i = decodeList.getBoolean(ASName.create("BlackIs1"));
        }
        return i;
    }

    public PDFXObjectImageSoftMask getSoftMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXObjectImageSoftMask.getInstance(this.getDictionaryCosObjectValue(ASName.k_SMask));
    }

    public void setSMask(PDFXObjectImageSoftMask value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_SMask, value);
    }

    public PDFXObjectImageSoftMask procureSoftMask() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasSoftMask()) {
            return PDFXObjectImageSoftMask.newInstance(this.getPDFDocument());
        }
        return this.getSoftMask();
    }

    public boolean hasSoftMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_SMask);
    }

    public PDFMeasure getMeasure() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMeasure.getInstance(this.getDictionaryCosObjectValue(ASName.k_Measure));
    }

    public void setMeasure(PDFMeasure value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Measure, value);
    }

    public boolean hasMeasure() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Measure);
    }

    public PDFPointData getPointData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPointData.getInstance(this.getDictionaryCosObjectValue(ASName.k_PtData));
    }

    public void setPointData(PDFPointData pdfPointData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_PtData, pdfPointData);
    }
}

