/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public abstract class PDFAction
extends PDFCosDictionary {
    protected PDFAction(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    protected PDFAction(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDocument));
        this.setType(ASName.k_Action);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    protected void setSubtype(ASName asName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_S, asName);
    }

    private void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, value);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    ArrayIterator arrayIterator() {
        return new ArrayIterator(this.getCosDictionary());
    }

    public ArrayIterator nextArrayIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new ArrayIterator(this.getDictionaryValue(ASName.k_Next));
    }

    public TreeIterator treeIterator() {
        return new TreeIterator(this.arrayIterator());
    }

    public TreeIterator nextTreeIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new TreeIterator(this.nextArrayIterator());
    }

    public boolean hasNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Next);
    }

    public void setNext(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Next, action);
    }

    public boolean isValid() {
        boolean isValid = false;
        CosObject cosObj = this.getCosObject();
        int cosType = cosObj.getType();
        isValid = cosType == 5 || cosType == 3 || cosType == 4 || cosType == 6 && ((CosDictionary)cosObj).containsKey(ASName.k_S);
        return isValid;
    }

    public static void addNextAction(PDFAction main, PDFAction next) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (main.hasNext()) {
            CosObject cosObj = main.getDictionaryCosObjectValue(ASName.k_Next);
            CosArray array = null;
            if (cosObj instanceof CosArray) {
                array = (CosArray)cosObj;
                array.add(next.getCosObject());
            } else if (cosObj instanceof CosDictionary) {
                array = main.getPDFDocument().getCosDocument().createCosArray();
                array.add(cosObj);
            } else {
                throw new PDFInvalidDocumentException("/Next entry in action should either be an array or dictionary");
            }
            main.setDictionaryValue(ASName.k_Next, array);
        } else {
            main.setNext(next);
        }
    }

    public final class TreeIterator {
        private final LinkedList ll = new LinkedList();
        private ArrayIterator currentArrayIter;
        private PDFAction nextAction;
        private PDFAction prevAction;

        protected TreeIterator(ArrayIterator arrayIter) {
            this.currentArrayIter = arrayIter;
            this.ll.add(arrayIter);
        }

        public boolean hasNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (this.nextAction == null) {
                if (this.prevAction != null) {
                    this.currentArrayIter = this.prevAction.nextArrayIterator();
                    this.ll.add(this.currentArrayIter);
                    this.prevAction = null;
                }
                while (this.currentArrayIter != null && !this.currentArrayIter.hasNext()) {
                    this.ll.removeLast();
                    if (!this.ll.isEmpty()) {
                        this.currentArrayIter = (ArrayIterator)this.ll.getLast();
                        continue;
                    }
                    this.currentArrayIter = null;
                }
                if (this.currentArrayIter != null && this.currentArrayIter.hasNext()) {
                    this.nextAction = this.currentArrayIter.next();
                }
            }
            return this.nextAction != null;
        }

        public PDFAction next() {
            if (this.nextAction == null) {
                throw new NoSuchElementException();
            }
            this.prevAction = this.nextAction;
            this.nextAction = null;
            return this.prevAction;
        }
    }

    public final class ArrayIterator {
        private final CosObject dictOrArray;
        private int index;
        private int size;

        protected ArrayIterator(CosObject dictOrArray) {
            this.dictOrArray = dictOrArray;
            this.size = dictOrArray == null ? 0 : (dictOrArray instanceof CosDictionary ? 1 : ((CosArray)dictOrArray).size());
        }

        public boolean hasNext() {
            return this.index < this.size;
        }

        public PDFAction next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                PDFAction action = this.dictOrArray instanceof CosDictionary ? PDFActionFactory.getInstance(this.dictOrArray) : PDFActionFactory.getInstance(((CosArray)this.dictOrArray).get(this.index));
                ++this.index;
                return action;
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("PDF error inside PDFAction.Iterator.next()");
                newException.initCause(e);
                throw newException;
            }
        }
    }
}

