/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionForm;
import java.io.IOException;

public class PDFActionJavaScript
extends PDFActionForm {
    private PDFActionJavaScript(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionJavaScript(PDFDocument pdfDocument, PDFText javaScript) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_JavaScript);
        this.setDictionaryValue(ASName.k_JS, javaScript);
    }

    private PDFActionJavaScript(PDFDocument pdfDocument, PDFStream js) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_JavaScript);
        this.setJavaScript(pdfDocument, js);
    }

    public static PDFActionJavaScript getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionJavaScript pdfObject = (PDFActionJavaScript)PDFCosObject.getCachedInstance(cosObject, PDFActionJavaScript.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionJavaScript(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionJavaScript newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionJS = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionJS.put(ASName.k_Type, ASName.k_Action);
        cosActionJS.put(ASName.k_S, ASName.k_JavaScript);
        return PDFActionJavaScript.getInstance(cosActionJS);
    }

    public static PDFActionJavaScript newInstance(PDFDocument pdfDocument, PDFText javaScript) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (javaScript == null) {
            throw new PDFInvalidDocumentException("JS is a required key");
        }
        return new PDFActionJavaScript(pdfDocument, javaScript);
    }

    public static PDFActionJavaScript newInstance(PDFDocument pdfDocument, PDFStream jsStream) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (jsStream == null) {
            throw new PDFInvalidDocumentException("JS is a required key");
        }
        return new PDFActionJavaScript(pdfDocument, jsStream);
    }

    public static PDFActionJavaScript newInstance(PDFDocument pdfDocument, InputByteStream javaScript) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (javaScript == null) {
            return null;
        }
        PDFStream jsStream = PDFStream.newInstance(pdfDocument);
        try {
            jsStream.setStreamData(javaScript.toInputStream());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return PDFActionJavaScript.newInstance(pdfDocument, jsStream);
    }

    public String getJavaScriptString() throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (this.getDictionaryTextStringOrStreamValue(ASName.k_JS) != null) {
            return this.getDictionaryTextStringOrStreamValue(ASName.k_JS);
        }
        return this.getDictionaryTextStringValue(ASName.k_JavaScript);
    }

    public void setJavaScript(PDFDocument pdfDocument, String js) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (js == null) {
            this.removeValue(ASName.k_JS);
        } else {
            this.setDictionaryTextValue(ASName.k_JS, PDFText.newInstance(js, true, pdfDocument));
        }
    }

    public void setJavaScript(PDFDocument pdfDocument, PDFStream jsStream) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (jsStream == null) {
            this.removeValue(ASName.k_JS);
        } else {
            this.setDictionaryStreamValue(ASName.k_JS, jsStream.getCosStream());
        }
    }

    public void removeJavaScript() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_JS);
    }

    public String getName() throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        return this.getDictionaryTextStringValue(ASName.k_Name);
    }

    public void setName(String name) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (name != null) {
            this.setDictionaryStringValue(ASName.k_Name, name);
        }
    }

    public void setName(String name, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (name != null) {
            this.setDictionaryStringValue(ASName.k_Name, name, unicode);
        }
    }
}

