/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationScreen;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMultimediaUtil;

public class PDFActionRendition
extends PDFAction {
    private PDFActionRendition(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionRendition(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_Rendition);
    }

    public static PDFActionRendition getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionRendition pdfObject = (PDFActionRendition)PDFCosObject.getCachedInstance(cosObject, PDFActionRendition.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionRendition(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionRendition newInstance(PDFDocument pdfDocument) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return new PDFActionRendition(pdfDocument);
    }

    public boolean hasRendition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_R);
    }

    public PDFCosDictionary getRendition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDFRendition", this.getDictionaryCosObjectValue(ASName.k_R));
    }

    public String getJavaScriptString() throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        String javaScript = this.getDictionaryTextStringOrStreamValue(ASName.k_JS);
        if (javaScript != null) {
            return javaScript;
        }
        return this.getDictionaryTextStringValue(ASName.k_JavaScript);
    }

    public void setJavaScript(PDFDocument pdfDocument, String js) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (js == null) {
            this.removeValue(ASName.k_JS);
        } else {
            this.setDictionaryTextValue(ASName.k_JS, PDFText.newInstance(js, true, pdfDocument));
        }
    }

    public void setJavaScript(PDFDocument pdfDocument, PDFStream jsStream) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (jsStream == null) {
            this.removeValue(ASName.k_JS);
        } else {
            this.setDictionaryStreamValue(ASName.k_JS, jsStream.getCosStream());
        }
    }

    public void removeJavaScript() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_JS);
    }

    public int getOperation() throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        return this.getDictionaryIntValue(ASName.k_OP);
    }

    public void setOperation(int value) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        this.setDictionaryIntValue(ASName.k_OP, value);
    }

    public PDFAnnotationScreen getAN() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationScreen.getInstance(this.getDictionaryCosObjectValue(ASName.k_AN));
    }

    public void setAN(PDFAnnotationScreen value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_AN, value);
    }

    public boolean hasAN() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_AN);
    }
}

