/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFRichMediaCommand;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRichMedia;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMultimediaUtil;

public class PDFActionRichMediaExecute
extends PDFAction {
    private PDFActionRichMediaExecute(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionRichMediaExecute(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_RichMediaExecute);
    }

    public static PDFActionRichMediaExecute getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionRichMediaExecute pdfObject = (PDFActionRichMediaExecute)PDFCosObject.getCachedInstance(cosObject, PDFActionRichMediaExecute.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionRichMediaExecute(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionRichMediaExecute newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFActionRichMediaExecute(pdfDocument);
    }

    public PDFAnnotationRichMedia getRichMediaAnnotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationRichMedia.getInstance(this.getDictionaryDictionaryValue(ASName.k_TA));
    }

    public void setRichMediaAnnotation(PDFAnnotationRichMedia annotationRichMedia) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_TA, annotationRichMedia);
    }

    public PDFCosDictionary getRichMediaInstance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDFRichMediaInstance", this.getDictionaryDictionaryValue(ASName.k_TI));
    }

    public void setRichMediaInstance(PDFCosDictionary richMediaInstance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_TI, richMediaInstance);
    }

    public PDFRichMediaCommand getRichMediaCommand() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaCommand.getInstance(this.getDictionaryCosObjectValue(ASName.k_CMD));
    }

    public void setRichMediaCommand(PDFRichMediaCommand richMediaInstance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_CMD, richMediaInstance);
    }
}

