/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMultimediaUtil;

public class PDFAnnotation3D
extends PDFAnnotation {
    private PDFAnnotation3D(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFAnnotation3D(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_3D);
    }

    public static PDFAnnotation3D newInstance(PDFDocument pdfDocument, PDFCosDictionary key_3DDictOrStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFMultimediaUtil.checkParameterType("com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DDDict", key_3DDictOrStream);
        if (key_3DDictOrStream == null) {
            throw new PDFInvalidParameterException("3DDictOrStream is required when creating newInstance of PDFAnnot3D.");
        }
        PDFAnnotation3D pdfObject = new PDFAnnotation3D(pdfDocument);
        pdfObject.set3DDictOrStream(key_3DDictOrStream);
        try {
            pdfObject.setStyle(ASName.k_Embedded);
        }
        catch (PDFInvalidParameterException pDFInvalidParameterException) {
            // empty catch block
        }
        return pdfObject;
    }

    public static PDFAnnotation3D getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotation3D pdfObject = (PDFAnnotation3D)PDFCosObject.getCachedInstance(cosObject, PDFAnnotation3D.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotation3D(cosObject);
        }
        return pdfObject;
    }

    public static PDFAnnotation3D newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotation3D(pdfDocument);
    }

    public PDFCosDictionary get3DA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDF3DADict", this.getDictionaryCosObjectValue(ASName.k_3DA));
    }

    public void set3DA(PDFCosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFMultimediaUtil.checkParameterType("com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DADict", value);
        if (value == null) {
            this.removeValue(ASName.k_3DA);
        } else {
            this.setDictionaryValue(ASName.k_3DA, value);
        }
    }

    public PDFCosDictionary procure3DA() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.has3DA()) {
            return PDFMultimediaUtil.createPDFMultimediaObject("PDF3DADict", this.getPDFDocument());
        }
        return this.get3DA();
    }

    public boolean has3DA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_3DA);
    }

    public boolean getInteractive() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_3DI);
    }

    public void setInteractive(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_3DI, value);
    }

    public boolean hasInteractive() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_3DI);
    }

    public PDFRectangle getBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(ASName.k_3DB);
        return PDFRectangle.getInstance(cosObject);
    }

    public void setBox(PDFRectangle value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_3DB, value);
    }

    public boolean hasBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_3DB);
    }

    public int get3DViewAsInteger() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_3DV);
    }

    public void set3DView(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_3DV, value);
    }

    public ASString get3DViewAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_3DV);
    }

    public void set3DView(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_3DV, value);
    }

    public void set3DView(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_3DV, value);
    }

    public ASName get3DViewAsName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_3DV);
    }

    public void set3DView(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryNameValue(ASName.k_3DV, value);
    }

    public PDFCosDictionary get3DViewAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDF3DVDict", this.getDictionaryCosObjectValue(ASName.k_3DV));
    }

    public void set3DView(PDFCosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_3DV, value);
    }

    public boolean has3DView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_3DV);
    }

    public PDFCosDictionary get3DDictOrStreamAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDF3DDDict", this.getDictionaryCosObjectValue(ASName.k_3DD));
    }

    public void set3DDictOrStream(PDFCosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFMultimediaUtil.checkParameterType("com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DDDict", value);
        if (value == null) {
            throw new PDFInvalidParameterException("3DDictOrStream is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_3DD, value);
    }

    public PDFCosStream get3DDictOrStreamAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (PDFCosStream)PDFMultimediaUtil.createPDFMultimediaObject("PDF3DDStream", this.getDictionaryCosObjectValue(ASName.k_3DD));
    }

    public void set3DDictOrStream(PDFCosStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFMultimediaUtil.checkParameterType("com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DDStream", value);
        if (value == null) {
            throw new PDFInvalidParameterException("3DDictOrStream is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_3DD, value);
    }

    public boolean has3DDictOrStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_3DD);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }

    public PDFCosDictionary get3DU() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDF3DUDict", this.getDictionaryCosObjectValue(ASName.k_3DU));
    }

    public void set3DU(PDFCosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFMultimediaUtil.checkParameterType("com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DUDict", value);
        this.setDictionaryValue(ASName.k_3DU, value);
    }

    public boolean has3DU() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_3DU);
    }

    public ASName getStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Style);
    }

    public void setStyle(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value != null && !value.equals(ASName.k_Embedded) && !value.equals(ASName.k_Windowed)) {
            throw new PDFInvalidParameterException("Style value is not valid. " + ASName.k_Embedded + " or " + ASName.k_Windowed + " is expected.");
        }
        this.setDictionaryNameValue(ASName.k_Style, value);
    }

    public boolean hasStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Style);
    }

    public PDFCosDictionary getWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDFRichMediaWindow", this.getDictionaryCosObjectValue(ASName.k_Window));
    }

    public void setWindow(PDFCosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFMultimediaUtil.checkParameterType("com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaWindow", value);
        this.setDictionaryValue(ASName.k_Window, value);
    }

    public boolean hasWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Window);
    }

    public boolean getTransparent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Transparent);
    }

    public void setTransparent(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Transparent, value);
    }

    public boolean hasTransparent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Transparent);
    }
}

