/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithIntent;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFLineIntentValue;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMeasure;
import java.util.ArrayList;
import java.util.List;

public class PDFAnnotationLine
extends PDFAnnotationMarkup
implements PDFAnnotationWithIntent {
    private PDFAnnotationLine(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationLine getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationLine pdfObject = (PDFAnnotationLine)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationLine.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationLine(cosObject);
        }
        return pdfObject;
    }

    private PDFAnnotationLine(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Line);
    }

    public static PDFAnnotationLine newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationLine(pdfDocument);
    }

    public static PDFAnnotationLine newInstance(PDFDocument pdfDocument, List<Double> coords) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (coords == null) {
            throw new PDFInvalidParameterException("Line Co-ordinates cann't be null");
        }
        PDFAnnotationLine pdfObject = PDFAnnotationLine.newInstance(pdfDocument);
        pdfObject.setLineCoords(coords);
        return pdfObject;
    }

    public double[] getInteriorColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationUtils.getInteriorColor(this);
    }

    public void setInteriorColor(double[] color) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationUtils.setInteriorColor(color, this);
    }

    public boolean hasLineCoords() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_L);
    }

    public double[] getLineCoords() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosLineCoords = this.getDictionaryArrayValue(ASName.k_L);
        if (cosLineCoords == null) {
            return null;
        }
        return cosLineCoords.getArrayDouble();
    }

    public void setLineCoords(List<Double> coords) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_L, coords);
    }

    private void transformLineCoords(ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.hasLineCoords()) {
            double[] lineCoords = this.getLineCoords();
            ArrayList<Double> newLineCoords = new ArrayList<Double>(lineCoords.length);
            for (int i = 0; i < lineCoords.length; i += 2) {
                ASCoordinate point = new ASCoordinate(lineCoords[i], lineCoords[i + 1]);
                ASCoordinate newPoint = point.transform(matrix);
                Double x = new Double(newPoint.x());
                Double y = new Double(newPoint.y());
                newLineCoords.add(i, x);
                newLineCoords.add(i + 1, y);
            }
            this.setLineCoords(newLineCoords);
        }
    }

    public void setLineCoords(double x1, double y1, double x2, double y2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
        cosArray.addDouble(x1);
        cosArray.addDouble(y1);
        cosArray.addDouble(x2);
        cosArray.addDouble(y2);
        this.setDictionaryArrayValue(ASName.k_L, cosArray);
    }

    public boolean hasLineEnds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_LE);
    }

    public boolean hasLeaderLineExtend() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_LLE);
    }

    public boolean hasLeaderLine() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_LL);
    }

    public double getLeaderLineExtend() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number value = this.getDictionaryNumericValue(ASName.k_LLE);
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    public double getLeaderLength() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number value = this.getDictionaryNumericValue(ASName.k_LL);
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    public void setLeaderLineExtend(double lineExtend) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_LLE, lineExtend);
    }

    public void setLeaderLength(double leaderLength) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_LL, leaderLength);
    }

    public boolean hasCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Cap);
    }

    public boolean hasLeaderLineOffset() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.K_LLO);
    }

    public boolean hasCaptionStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CSTYLE);
    }

    public boolean hasMeasure() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MEASURE);
    }

    public boolean hasCaptionOffset() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_COFF);
    }

    public boolean getCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Cap);
    }

    public double getLeaderLineOffset() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number value = this.getDictionaryNumericValue(ASName.K_LLO);
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    public String getCaptionStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValueAsString(ASName.k_CSTYLE);
    }

    public PDFMeasure getMeasure() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMeasure.getInstance(this.getDictionaryDictionaryValue(ASName.k_MEASURE));
    }

    public double[] getCaptionOffset() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_COFF);
        double[] captionOffset = new double[]{cosArray.getDouble(0), cosArray.getDouble(1)};
        return captionOffset;
    }

    public void setLeaderLineOffset(double llo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.K_LLO, (long)llo);
    }

    public void setCaptionStyle(String cs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_CSTYLE, ASName.create(cs));
    }

    public void setMeasure(PDFMeasure measure) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_MEASURE, measure);
    }

    public void setCaptionOffset(double[] co) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
        cosArray.addDouble(co[0]);
        cosArray.addDouble(co[1]);
        this.setDictionaryArrayValue(ASName.k_COFF, cosArray);
    }

    public LineEnding[] getLineEnds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_LE);
        if (cosArray == null) {
            return new LineEnding[]{LineEnding.None, LineEnding.None};
        }
        LineEnding[] lineEndings = new LineEnding[]{LineEnding.getInstance(cosArray.getName(0)), LineEnding.getInstance(cosArray.getName(1))};
        return lineEndings;
    }

    public void setLineEnds(LineEnding[] lineEndings) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
        cosArray.addName(lineEndings[0].getValue());
        cosArray.addName(lineEndings[1].getValue());
        this.setDictionaryArrayValue(ASName.k_LE, cosArray);
    }

    public void setCaption(String caption) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Cap, "yes".equals(caption));
    }

    public void setCaption(boolean caption) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Cap, caption);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformLineCoords(matrix);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }

    @Override
    protected boolean isIntentTypeValid(String intentType) {
        return PDFLineIntentValue.getInstance(intentType) != null;
    }

    public void setCP(CaptionPosition captionPosition) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (captionPosition == null) {
            this.removeValue(ASName.k_CP);
        } else {
            this.setDictionaryStringValue(ASName.k_CP, captionPosition.toString());
        }
    }

    public CaptionPosition getCP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString captionPosition = this.getDictionaryStringValue(ASName.k_CP);
        if (captionPosition == null) {
            return CaptionPosition.Inline;
        }
        return CaptionPosition.getInstance(captionPosition.asString());
    }

    @Override
    public void applyRotation(PDFRectangle cropBox, int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (rotationAngle == 0) {
            rotationAngle = this.getRotation();
        }
        double height = cropBox.height();
        double width = cropBox.width();
        double[] transformedRect = null;
        double[] transformedCords = null;
        double[] transformedPopupRect = null;
        PDFAnnotationPopup popup = this.getPopup();
        transformedRect = PDFAnnotationUtils.transfromRectangle(this.getRect().getValues(), width, height, rotationAngle);
        transformedCords = PDFAnnotationUtils.transfromRectangle(this.getLineCoords(), width, height, rotationAngle);
        if (popup != null) {
            transformedPopupRect = PDFAnnotationUtils.transfromRectangle(this.getPopup().getRect().getValues(), width, height, rotationAngle);
        }
        this.setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedRect[0], transformedRect[1], transformedRect[2], transformedRect[3]));
        this.setLineCoords(transformedCords[0], transformedCords[1], transformedCords[2], transformedCords[3]);
        if (popup != null) {
            this.getPopup().setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedPopupRect[0], transformedPopupRect[1], transformedPopupRect[2], transformedPopupRect[3]));
        }
    }

    public static final class LineEnding {
        private final ASName value;
        public static final LineEnding Square = new LineEnding(ASName.create("Square"));
        public static final LineEnding Circle = new LineEnding(ASName.create("Circle"));
        public static final LineEnding Diamond = new LineEnding(ASName.create("Diamond"));
        public static final LineEnding OpenArrow = new LineEnding(ASName.create("OpenArrow"));
        public static final LineEnding ClosedArrow = new LineEnding(ASName.create("ClosedArrow"));
        public static final LineEnding None = new LineEnding(ASName.create("None"));
        public static final LineEnding Butt = new LineEnding(ASName.create("Butt"));
        public static final LineEnding ROpenArrow = new LineEnding(ASName.create("ROpenArrow"));
        public static final LineEnding RClosedArrow = new LineEnding(ASName.create("RClosedArrow"));
        public static final LineEnding Slash = new LineEnding(ASName.create("Slash"));

        private LineEnding(ASName value) {
            this.value = value;
        }

        ASName getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.asString(true);
        }

        public static LineEnding getInstance(String lineEnding) {
            return LineEnding.getInstance(ASName.create(lineEnding));
        }

        private static LineEnding getInstance(ASName value) {
            if (value == Square.getValue()) {
                return Square;
            }
            if (value == Circle.getValue()) {
                return Circle;
            }
            if (value == Diamond.getValue()) {
                return Diamond;
            }
            if (value == OpenArrow.getValue()) {
                return OpenArrow;
            }
            if (value == ClosedArrow.getValue()) {
                return ClosedArrow;
            }
            if (value == None.getValue()) {
                return None;
            }
            if (value == Butt.getValue()) {
                return Butt;
            }
            if (value == ROpenArrow.getValue()) {
                return ROpenArrow;
            }
            if (value == RClosedArrow.getValue()) {
                return RClosedArrow;
            }
            if (value == Slash.getValue()) {
                return Slash;
            }
            return new LineEnding(value);
        }
    }

    public static enum CaptionPosition {
        Inline("Inline"),
        Top("Top");

        private final String value;

        private CaptionPosition(String value) {
            this.value = value;
        }

        public static CaptionPosition getInstance(String value) {
            return CaptionPosition.valueOf(value);
        }

        public String toString() {
            return this.value;
        }
    }
}

