/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import java.util.Iterator;
import java.util.List;

public class PDFAnnotationList
extends PDFCosObject {
    PDFAnnotationArrayList mAnnotationArrayList;

    private PDFAnnotationList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
        this.mAnnotationArrayList = new PDFAnnotationArrayList(cosObject);
    }

    public static PDFAnnotationList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationList pdfObject = (PDFAnnotationList)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationList.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationList(cosObject);
        }
        return pdfObject;
    }

    public static PDFAnnotationList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFAnnotationList pdfObject = new PDFAnnotationList(cosObject);
        return pdfObject;
    }

    public PDFAnnotation findAnnotation(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotation curAnnot = null;
        int annotInd = 0;
        for (annotInd = 0; annotInd < this.size(); ++annotInd) {
            curAnnot = this.get(annotInd);
            if (curAnnot == null || !name.equals(curAnnot.getName())) continue;
            return curAnnot;
        }
        return null;
    }

    public List<PDFAnnotation> getArrayList() {
        return this.mAnnotationArrayList;
    }

    public void add(int index, PDFAnnotation element) {
        this.mAnnotationArrayList.add(index, element);
    }

    public boolean add(PDFAnnotation o) {
        return this.mAnnotationArrayList.add(o);
    }

    public void addAnnotations(PDFAnnotationList annots) {
        this.mAnnotationArrayList.addList((PDFCosArrayList)annots.getArrayList());
    }

    public void clear() {
        this.mAnnotationArrayList.clear();
    }

    public boolean contains(PDFAnnotation o) {
        return this.mAnnotationArrayList.contains(o);
    }

    public PDFAnnotation get(int index) {
        return (PDFAnnotation)this.mAnnotationArrayList.get(index);
    }

    public int indexOf(PDFAnnotation o) {
        return this.mAnnotationArrayList.indexOf(o);
    }

    public boolean isEmpty() {
        return this.mAnnotationArrayList.isEmpty();
    }

    public PDFAnnotationIterator iterator() {
        return new PDFAnnotationListIterator(this.mAnnotationArrayList);
    }

    public int lastIndexOf(PDFAnnotation o) {
        return this.mAnnotationArrayList.lastIndexOf(o);
    }

    public PDFAnnotation remove(int index) {
        return (PDFAnnotation)this.mAnnotationArrayList.remove(index);
    }

    public boolean remove(PDFAnnotation o) {
        return this.mAnnotationArrayList.remove(o);
    }

    public PDFAnnotation set(int index, PDFAnnotation element) {
        return this.mAnnotationArrayList.set(index, element);
    }

    public int size() {
        return this.mAnnotationArrayList.size();
    }

    public PDFAnnotation[] toArray() {
        Object[] theArray = new PDFAnnotation[this.mAnnotationArrayList.size()];
        return (PDFAnnotation[])this.mAnnotationArrayList.toArray(theArray);
    }

    public PDFAnnotation[] toArray(PDFAnnotation[] a) {
        return (PDFAnnotation[])this.mAnnotationArrayList.toArray(a);
    }

    static class PDFAnnotationListIterator
    implements PDFAnnotationIterator {
        Iterator<PDFAnnotation> mAnnotsIter;

        PDFAnnotationListIterator(PDFAnnotationArrayList annotationArrayList) {
            this.mAnnotsIter = annotationArrayList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mAnnotsIter.hasNext();
        }

        @Override
        public PDFAnnotation next() {
            return this.mAnnotsIter.next();
        }

        @Override
        public void remove() {
            this.mAnnotsIter.remove();
        }
    }

    static class PDFAnnotationArrayList
    extends PDFCosArrayList<PDFAnnotation> {
        private PDFAnnotationArrayList(CosObject cosObject) throws PDFInvalidDocumentException {
            super(cosObject);
        }

        @Override
        protected PDFAnnotation itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return PDFAnnotationFactory.getInstance(cosObject);
        }
    }
}

