/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFTrapNetAnnotStates;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFTrapNetFontFauxingList;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFTrapNetVersion;

public class PDFAnnotationTrapNet
extends PDFAnnotation {
    private PDFAnnotationTrapNet(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationTrapNet getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationTrapNet pdfObject = (PDFAnnotationTrapNet)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationTrapNet.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationTrapNet(cosObject);
        }
        return pdfObject;
    }

    private PDFAnnotationTrapNet(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_TrapNet);
    }

    public static PDFAnnotationTrapNet newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationTrapNet(pdfDocument);
    }

    public boolean hasLastModified() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_LastModified);
    }

    public ASDate getLastModified() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_LastModified);
    }

    public void setLastModified(ASDate lastModified) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (lastModified == null) {
            this.removeValue(ASName.k_LastModified);
            return;
        }
        this.setDictionaryStringValue(ASName.k_LastModified, lastModified.asString());
        if (this.dictionaryContains(ASName.k_Version)) {
            this.removeValue(ASName.k_Version);
        }
        if (this.dictionaryContains(ASName.k_AnnotStates)) {
            this.removeValue(ASName.k_AnnotStates);
        }
    }

    public boolean hasVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Version);
    }

    public PDFTrapNetVersion getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosVerion = this.getDictionaryArrayValue(ASName.k_Version);
        return PDFTrapNetVersion.getInstance(cosVerion);
    }

    public void setVersion(PDFTrapNetVersion version) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Version, version);
        if (this.dictionaryContains(ASName.k_LastModified)) {
            this.removeValue(ASName.k_LastModified);
        }
    }

    public boolean hasAnnotStates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_AnnotStates);
    }

    public PDFTrapNetAnnotStates getAnnotStates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosStates = this.getDictionaryArrayValue(ASName.k_AnnotStates);
        return PDFTrapNetAnnotStates.getInstance(cosStates);
    }

    public void setAnnotStates(PDFTrapNetAnnotStates states) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_AnnotStates, states);
        if (this.dictionaryContains(ASName.k_LastModified)) {
            this.removeValue(ASName.k_LastModified);
        }
    }

    public boolean hasFontFauxingList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_FontFauxing);
    }

    public PDFTrapNetFontFauxingList getFontFauxingList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosStates = this.getDictionaryArrayValue(ASName.k_FontFauxing);
        return PDFTrapNetFontFauxingList.getInstance(cosStates);
    }

    public void setFontFauxingList(PDFTrapNetFontFauxingList list) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_FontFauxing, list);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }
}

