/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import java.util.ArrayList;
import java.util.List;

public class PDFAppearance
extends PDFCosDictionary {
    private PDFAppearance(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFAppearance getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAppearance pdfObject = (PDFAppearance)PDFCosObject.getCachedInstance(cosObject, PDFAppearance.class);
        if (pdfObject == null) {
            pdfObject = new PDFAppearance(cosObject);
        }
        return pdfObject;
    }

    public static PDFAppearance newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        PDFAppearance pdfObject = new PDFAppearance(cosObject);
        return pdfObject;
    }

    private List<ASName> getAppearanceStates(ASName appearanceName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosAppearance = this.getDictionaryCosObjectValue(appearanceName);
        if (cosAppearance == null) {
            return null;
        }
        if (cosAppearance.getType() == 7) {
            return new ArrayList<ASName>();
        }
        return ((CosDictionary)cosAppearance).getKeys();
    }

    public PDFXObjectForm getAppearance(ASName appearanceName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (appearanceName == null) {
            appearanceName = ASName.k_N;
        }
        return appearanceName.equals(ASName.k_N) ? this.getNormalAppearance() : (appearanceName.equals(ASName.k_D) ? this.getDownAppearance() : (appearanceName.equals(ASName.k_R) ? this.getRolloverAppearance() : null));
    }

    public PDFXObjectForm getAppearance(ASName appearanceName, ASName state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosAppearance = this.getDictionaryCosObjectValue(appearanceName);
        if (cosAppearance == null) {
            return null;
        }
        if (cosAppearance.getType() == 7) {
            return PDFXObjectForm.getInstance(cosAppearance);
        }
        if (((CosDictionary)cosAppearance).containsKey(state)) {
            return PDFXObjectForm.getInstance(((CosDictionary)cosAppearance).getCosStream(state));
        }
        return null;
    }

    public PDFAppearance setAppearance(ASName appearanceName, ASName state, PDFXObjectForm appearanceStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary subDict;
        PDFAppearance curAppearance = this;
        if (state == null) {
            this.setDictionaryValue(appearanceName, appearanceStream);
            return curAppearance;
        }
        if (this.getCosObject().getType() == 7) {
            curAppearance = PDFAppearance.newInstance(this.getPDFDocument());
        }
        if ((subDict = curAppearance.getDictionaryDictionaryValue(appearanceName)) == null) {
            subDict = PDFCosObject.newCosDictionary(this.getPDFDocument());
            curAppearance.setDictionaryValue(appearanceName, subDict);
        }
        subDict.put(state, appearanceStream.getCosObject());
        return curAppearance;
    }

    public PDFXObjectForm getNormalAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getNormalAppearance(null);
    }

    public PDFXObjectForm getNormalAppearance(ASName state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getAppearance(ASName.k_N, state);
    }

    public List<ASName> getNormalAppearanceStates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getAppearanceStates(ASName.k_N);
    }

    public PDFAppearance setNormalStateAppearance(ASName state, PDFXObjectForm xObjForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.setAppearance(ASName.k_N, state, xObjForm);
    }

    public void setNormalAppearance(PDFXObjectForm xObjForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setNormalStateAppearance(null, xObjForm);
    }

    public PDFXObjectForm getRolloverAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getRolloverAppearance(null);
    }

    public PDFXObjectForm getRolloverAppearance(ASName state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getAppearance(ASName.k_R, state);
    }

    public List<ASName> getRolloverAppearanceStates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getAppearanceStates(ASName.k_R);
    }

    public PDFAppearance setRolloverStateAppearance(ASName state, PDFXObjectForm xObjForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.setAppearance(ASName.k_R, state, xObjForm);
    }

    public void setRolloverAppearance(PDFXObjectForm xObjForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setRolloverStateAppearance(null, xObjForm);
    }

    public PDFXObjectForm getDownAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDownAppearance(null);
    }

    public PDFXObjectForm getDownAppearance(ASName state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getAppearance(ASName.k_D, state);
    }

    public List<ASName> getDownAppearanceStates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getAppearanceStates(ASName.k_D);
    }

    public PDFAppearance setDownStateAppearance(ASName state, PDFXObjectForm xObjForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.setAppearance(ASName.k_D, state, xObjForm);
    }

    public void setDownAppearance(PDFXObjectForm xObjForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDownStateAppearance(null, xObjForm);
    }
}

