/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import java.util.ArrayList;

public class PDFBorderStyle
extends PDFCosDictionary {
    private PDFBorderStyle(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFBorderStyle getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFBorderStyle pdfObject = (PDFBorderStyle)PDFCosObject.getCachedInstance(cosObject, PDFBorderStyle.class);
        if (pdfObject == null) {
            pdfObject = new PDFBorderStyle(cosObject);
        }
        return pdfObject;
    }

    public static PDFBorderStyle newInstance(PDFDocument pdfDocument, double width, Style style, long[] dash) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBorderStyle pdfObject = PDFBorderStyle.newInstance(pdfDocument);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_Border);
        pdfObject.setDictionaryDoubleValue(ASName.k_W, width);
        if (style != null) {
            pdfObject.setDictionaryNameValue(ASName.k_S, style.getValue());
        }
        if (dash != null) {
            pdfObject.setDictionaryArrayValue(ASName.k_D, dash);
        }
        return pdfObject;
    }

    static PDFBorderStyle newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFBorderStyle pdfObject = new PDFBorderStyle(cosObject);
        return pdfObject;
    }

    public double getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number width = this.getDictionaryNumericValue(ASName.k_W);
        if (width == null) {
            return 1.0;
        }
        return width.doubleValue();
    }

    public void setWidth(String width) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_W, width);
    }

    public boolean hasWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_W);
    }

    public Style getStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return Style.getInstance(this.getDictionaryNameValue(ASName.k_S));
    }

    public void setStyle(Style style) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_S, style.value);
    }

    public boolean hasStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public double[] getDash() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosDash = (CosArray)this.getDictionaryCosObjectValue(ASName.k_D);
        return cosDash.getArrayDouble();
    }

    public void setDash(String dashes, String separator) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Double> dashArray = PDFUtil.parseNumbers(dashes, separator);
        this.setDash(dashArray);
    }

    public void setDash(ArrayList<?> dashArray) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (dashArray == null) {
            this.removeValue(ASName.k_D);
            return;
        }
        this.setDictionaryArrayValue(ASName.k_D, dashArray);
    }

    public boolean hasDash() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_D);
    }

    public static enum Style {
        Solid(ASName.k_S),
        Dashed(ASName.k_D),
        Beveled(ASName.k_B),
        Inset(ASName.k_I),
        Underline(ASName.k_U);

        private final ASName value;

        private Style(ASName value) {
            this.value = value;
        }

        public ASName getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.asString(true);
        }

        public static Style getInstance(String stringValue) {
            return Style.getInstance(ASName.create(stringValue));
        }

        private static final Style getInstance(ASName value) {
            if (value != null) {
                if (value.equals(Solid.getValue())) {
                    return Solid;
                }
                if (value.equals(Dashed.getValue())) {
                    return Dashed;
                }
                if (value.equals(Beveled.getValue())) {
                    return Beveled;
                }
                if (value.equals(Inset.getValue())) {
                    return Inset;
                }
                if (value.equals(Underline.getValue())) {
                    return Underline;
                }
            }
            return null;
        }
    }
}

