/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.ArrayList;

public class PDFFixedPrint
extends PDFCosDictionary {
    private PDFFixedPrint(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFixedPrint getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFixedPrint pdfObject = (PDFFixedPrint)PDFCosObject.getCachedInstance(cosObject, PDFFixedPrint.class);
        if (pdfObject == null) {
            pdfObject = new PDFFixedPrint(cosObject);
        }
        return pdfObject;
    }

    public static PDFFixedPrint newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFFixedPrint pdfObject = new PDFFixedPrint(cosObject);
        return pdfObject;
    }

    public ASMatrix getTransformation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_Matrix)) {
            return new ASMatrix(this.getDictionaryArrayValue(ASName.k_Matrix).getArrayDouble());
        }
        return ASMatrix.createIdentityMatrix();
    }

    public void setTransformation(ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        ArrayList<Double> entries = new ArrayList<Double>(6);
        entries.add(0, matrix.geta());
        entries.add(1, matrix.getb());
        entries.add(2, matrix.getc());
        entries.add(3, matrix.getd());
        entries.add(4, matrix.getx());
        entries.add(5, matrix.gety());
        this.setDictionaryArrayValue(ASName.k_Matrix, entries);
    }

    public double getHorizontalTransformation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_H)) {
            return this.getDictionaryNumericValue(ASName.k_H).doubleValue();
        }
        return 0.0;
    }

    public void setHorizontalTransformation(double trans) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_H, trans);
    }

    public double getVerticalTransformation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_V)) {
            return this.getDictionaryNumericValue(ASName.k_V).doubleValue();
        }
        return 0.0;
    }

    public void setVerticalTransformation(double trans) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_V, trans);
    }
}

