/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFInk;
import java.util.List;

public class PDFInkList
extends PDFCosArrayList<PDFInk> {
    private PDFInkList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFInkList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFInkList pdfObject = (PDFInkList)PDFCosObject.getCachedInstance(cosObject, PDFInkList.class);
        if (pdfObject == null) {
            pdfObject = new PDFInkList(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFInk itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException {
        return PDFInk.getInstance(cosObject);
    }

    public static PDFInkList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFInkList pdfObject = new PDFInkList(cosObject);
        return pdfObject;
    }

    public void addPath(List<? extends Number> path) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInk ink = PDFInk.getInstance(PDFCosObject.makeCosArray(this.getPDFDocument(), path));
        super.add(ink);
    }

    public void setPaths(List<List<? extends Number>> paths) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        for (List<? extends Number> path : paths) {
            PDFInk ink = PDFInk.getInstance(PDFCosObject.makeCosArray(this.getPDFDocument(), path));
            super.add(ink);
        }
    }
}

