/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFDefaultAppearance
extends PDFCosObject {
    private PDFDefaultAppearance(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFDefaultAppearance getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        Object object = PDFCosObject.getCachedInstance(cosObject, PDFDefaultAppearance.class);
        PDFDefaultAppearance pdfObject = (PDFDefaultAppearance)object;
        if (pdfObject == null) {
            pdfObject = new PDFDefaultAppearance(cosObject);
        }
        return pdfObject;
    }

    public static PDFDefaultAppearance newInstance(PDFDocument pdfDocument, byte[] bytes) throws PDFInvalidDocumentException {
        CosString cosObject = PDFCosObject.newCosString(pdfDocument, bytes);
        return new PDFDefaultAppearance(cosObject);
    }

    public static PDFDefaultAppearance newInstance(PDFDocument pdfDocument, String stringValue) throws PDFInvalidDocumentException {
        CosString cosObject = PDFCosObject.newCosString(pdfDocument, stringValue);
        return new PDFDefaultAppearance(cosObject);
    }

    public static PDFDefaultAppearance newInstance(PDFDocument pdfDocument, ASName fontResourceName, int size, double greyValue) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException {
        CosString cosObject = PDFCosObject.newCosString(pdfDocument, "/" + fontResourceName.asString() + " " + String.valueOf(size) + " Tf " + ASNumber.doubleToString(greyValue) + " g");
        return new PDFDefaultAppearance(cosObject);
    }

    public static PDFDefaultAppearance newInstance(PDFDocument pdfDocument, ASName fontResourceName, double size, double[] color) throws PDFInvalidDocumentException {
        StringBuilder daStr = new StringBuilder();
        daStr.append("/").append(fontResourceName.asString()).append(" ").append(ASNumber.doubleToString(size)).append(" Tf ");
        if (color != null && color.length > 0) {
            if (color.length == 1) {
                daStr.append(ASNumber.doubleToString(color[0])).append(" g");
            } else if (color.length == 3) {
                daStr.append(ASNumber.doubleToString(color[0])).append(" ").append(ASNumber.doubleToString(color[1])).append(" ").append(ASNumber.doubleToString(color[2])).append(" rg");
            } else if (color.length == 4) {
                daStr.append(ASNumber.doubleToString(color[0])).append(" ").append(ASNumber.doubleToString(color[1])).append(" ").append(ASNumber.doubleToString(color[2])).append(" ").append(ASNumber.doubleToString(color[3])).append(" k");
            }
        }
        return new PDFDefaultAppearance(PDFCosObject.newCosString(pdfDocument, daStr.toString()));
    }

    public String asString() throws PDFSecurityException {
        CosObject cosValue = this.getCosObject();
        if (cosValue == null) {
            return null;
        }
        if (cosValue.getType() != 4) {
            return null;
        }
        ASString value = cosValue.stringValue();
        return value == null ? null : value.asString();
    }

    public byte[] asByteArray() throws PDFSecurityException {
        CosObject cosValue = this.getCosObject();
        if (cosValue == null) {
            return null;
        }
        if (cosValue.getType() != 4) {
            return null;
        }
        CosString cosStringValue = (CosString)cosValue;
        return cosStringValue.byteArrayValue();
    }
}

