/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;

public class PDFXFAPacket {
    private final ASString packetName;
    private final PDFStream dataStream;

    PDFXFAPacket(ASString packetName, PDFStream dataStream) throws PDFInvalidParameterException {
        if (packetName == null) {
            throw new PDFInvalidParameterException("XFA Packet name can't be null");
        }
        if (dataStream == null) {
            throw new PDFInvalidParameterException("XFA Data Stream can't be null");
        }
        this.packetName = packetName;
        this.dataStream = dataStream;
    }

    public ASString getPacketName() {
        return this.packetName;
    }

    public PDFStream getDataStream() {
        return this.dataStream;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PDFXFAPacket)) {
            return false;
        }
        PDFXFAPacket otherPacket = (PDFXFAPacket)obj;
        return this.packetName.equals(otherPacket.packetName) && this.dataStream.equals(otherPacket.dataStream);
    }

    public int hashCode() {
        return this.packetName.hashCode() ^ this.dataStream.hashCode();
    }
}

