/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.geospatial;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;

public class PDFCoordinateSystem
extends PDFCosDictionary {
    protected PDFCoordinateSystem(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCoordinateSystem getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCoordinateSystem pdfObject = (PDFCoordinateSystem)PDFCosObject.getCachedInstance(cosObject, PDFCoordinateSystem.class);
        if (pdfObject == null) {
            pdfObject = new PDFCoordinateSystem(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public Integer getEPSG() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_EPSG);
    }

    public void setEPSG(Integer code) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (code == null) {
            this.removeValue(ASName.k_EPSG);
        } else {
            this.setDictionaryIntValue(ASName.k_EPSG, code.intValue());
        }
    }

    public ASName getWKT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_WKT);
    }

    public void setWKT(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_WKT, value);
    }
}

