/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.geospatial;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.geospatial.PDFCoordinateSystem;

public class PDFGeographicCoordinateSystem
extends PDFCoordinateSystem {
    private PDFGeographicCoordinateSystem(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFGeographicCoordinateSystem newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFGeographicCoordinateSystem pdfObject = new PDFGeographicCoordinateSystem(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_GEOGCS);
        return pdfObject;
    }

    public static PDFGeographicCoordinateSystem getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFGeographicCoordinateSystem pdfObject = (PDFGeographicCoordinateSystem)PDFCosObject.getCachedInstance(cosObject, PDFGeographicCoordinateSystem.class);
        if (pdfObject == null) {
            pdfObject = new PDFGeographicCoordinateSystem(cosObject);
        }
        return pdfObject;
    }
}

