/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.geospatial;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.ArrayList;
import java.util.List;

public class PDFPointData
extends PDFCosDictionary {
    private PDFPointData(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPointData newInstance(PDFDocument pdfDocument, List<ASName> names, List<List<PDFCosObjectContainer>> xpts) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (names == null) {
            throw new PDFInvalidParameterException("names is required when creating newInstance of PDFPointData.");
        }
        if (xpts == null) {
            throw new PDFInvalidParameterException("xpts is required when creating newInstance of PDFPointData.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFPointData pdfObject = new PDFPointData(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_PtData);
        pdfObject.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Cloud);
        pdfObject.setNames(names);
        pdfObject.setXPTS(xpts);
        return pdfObject;
    }

    public static PDFPointData getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPointData pdfObject = (PDFPointData)PDFCosObject.getCachedInstance(cosObject, PDFPointData.class);
        if (pdfObject == null) {
            pdfObject = new PDFPointData(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public ASName getSubType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_SubType);
    }

    public ArrayList<ASName> getNames() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray entries = this.getDictionaryArrayValue(ASName.k_Names);
        if (entries != null) {
            int count = entries.size();
            ArrayList<ASName> result = new ArrayList<ASName>(count);
            for (int i = 0; i < count; ++i) {
                result.add(entries.getName(i));
            }
            return result;
        }
        return null;
    }

    public void setNames(List<ASName> categories) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (categories == null) {
            throw new PDFInvalidParameterException("names is required when creating newInstance of PDFPointData.");
        }
        this.setDictionaryArrayValue(ASName.k_Names, categories);
    }

    public List<List<PDFCosObjectContainer>> getXPTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray entries = this.getDictionaryArrayValue(ASName.k_XPTS);
        if (entries != null) {
            int count = entries.size();
            ArrayList<List<PDFCosObjectContainer>> result = new ArrayList<List<PDFCosObjectContainer>>();
            for (int i = 0; i < count; ++i) {
                CosArray singleEntry = entries.getCosArray(i);
                ArrayList<PDFCosObjectContainer> subArray = new ArrayList<PDFCosObjectContainer>();
                for (int j = 0; j < singleEntry.size(); ++j) {
                    subArray.add((PDFCosObjectContainer)((Object)singleEntry.get(j)));
                }
                result.add(subArray);
            }
            return result;
        }
        return null;
    }

    public void setXPTS(List<List<PDFCosObjectContainer>> xpts) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (xpts == null) {
            throw new PDFInvalidParameterException("xpts is required when creating newInstance of PDFPointData.");
        }
        CosArray xptsArray = PDFCosObject.newCosArray(this.getPDFDocument());
        for (List<PDFCosObjectContainer> entry : xpts) {
            CosArray subArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (PDFCosObjectContainer name : entry) {
                subArray.add(name.getPDFCosObject().getCosObject());
            }
            xptsArray.add(subArray);
        }
        this.setDictionaryArrayValue(ASName.k_Names, xptsArray);
    }
}

