/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageFit;

public class PDFDestinationExplicit
extends PDFDestination {
    private PDFDestinationExplicit(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFDestinationExplicit getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFDestinationExplicit pdfObject = (PDFDestinationExplicit)PDFCosObject.getCachedInstance(cosObject, PDFDestinationExplicit.class);
        if (pdfObject == null) {
            pdfObject = new PDFDestinationExplicit(cosObject);
        }
        return pdfObject;
    }

    public static PDFDestinationExplicit newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestinationExplicit.getInstance(PDFCosObject.newCosArray(pdfDocument));
    }

    public static PDFDestinationExplicit newDestXYZ(PDFPage page, float left, float top, float zoom) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(page.getPDFDocument());
        cosArray.add(page.getCosObject());
        cosArray.addName(PDFPageFit.XYZ.getName());
        cosArray.addDouble(left);
        cosArray.addDouble(top);
        cosArray.addDouble(zoom);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFit(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(page.getPDFDocument());
        CosObject cosPage = page.getCosObject();
        cosArray.add(cosPage);
        cosArray.addName(PDFPageFit.Fit.getName());
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitH(PDFPage page, float top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(page.getPDFDocument());
        cosArray.add(page.getCosObject());
        cosArray.addName(PDFPageFit.FitH.getName());
        cosArray.addDouble(top);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitV(PDFPage page, float left) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(page.getPDFDocument());
        cosArray.add(page.getCosObject());
        cosArray.addName(PDFPageFit.FitV.getName());
        cosArray.addDouble(left);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitR(PDFPage page, float left, float bottom, float right, float top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(page.getPDFDocument());
        cosArray.add(page.getCosObject());
        cosArray.addName(PDFPageFit.FitR.getName());
        cosArray.addDouble(left);
        cosArray.addDouble(bottom);
        cosArray.addDouble(right);
        cosArray.addDouble(top);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitB(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(page.getPDFDocument());
        CosObject cosPage = page.getCosObject();
        cosArray.add(cosPage);
        cosArray.addName(PDFPageFit.FitB.getName());
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitBH(PDFPage page, float top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(page.getPDFDocument());
        cosArray.add(page.getCosObject());
        cosArray.addName(PDFPageFit.FitBH.getName());
        cosArray.addDouble(top);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitBV(PDFPage page, float left) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(page.getPDFDocument());
        cosArray.add(page.getCosObject());
        cosArray.addName(PDFPageFit.FitBV.getName());
        cosArray.addDouble(left);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestXYZ(PDFDocument pdfDoc, PDFPage page, Double left, Double top, Double zoom) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(pdfDoc);
        CosObject cosPage = page != null ? page.getCosObject() : PDFCosObject.newCosNull(pdfDoc);
        cosArray.add(cosPage);
        cosArray.addName(PDFPageFit.XYZ.getName());
        PDFDestinationExplicit.addDoubleValue(cosArray, left);
        PDFDestinationExplicit.addDoubleValue(cosArray, top);
        PDFDestinationExplicit.addDoubleValue(cosArray, zoom);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFit(PDFDocument pdfDoc, PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(pdfDoc);
        CosObject cosPage = page != null ? page.getCosObject() : PDFCosObject.newCosNull(pdfDoc);
        cosArray.add(cosPage);
        cosArray.addName(PDFPageFit.Fit.getName());
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitH(PDFDocument pdfDoc, PDFPage page, Double top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(pdfDoc);
        CosObject cosPage = page != null ? page.getCosObject() : PDFCosObject.newCosNull(pdfDoc);
        cosArray.add(cosPage);
        cosArray.addName(PDFPageFit.FitH.getName());
        PDFDestinationExplicit.addDoubleValue(cosArray, top);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitV(PDFDocument pdfDoc, PDFPage page, Double left) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(pdfDoc);
        CosObject cosPage = page != null ? page.getCosObject() : PDFCosObject.newCosNull(pdfDoc);
        cosArray.add(cosPage);
        cosArray.addName(PDFPageFit.FitV.getName());
        PDFDestinationExplicit.addDoubleValue(cosArray, left);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitR(PDFDocument pdfDoc, PDFPage page, Double left, Double bottom, Double right, Double top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(pdfDoc);
        CosObject cosPage = page != null ? page.getCosObject() : PDFCosObject.newCosNull(pdfDoc);
        cosArray.add(cosPage);
        cosArray.addName(PDFPageFit.FitR.getName());
        PDFDestinationExplicit.addDoubleValue(cosArray, left);
        PDFDestinationExplicit.addDoubleValue(cosArray, bottom);
        PDFDestinationExplicit.addDoubleValue(cosArray, right);
        PDFDestinationExplicit.addDoubleValue(cosArray, top);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitBH(PDFDocument pdfDoc, PDFPage page, Double top) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(pdfDoc);
        CosObject cosPage = page != null ? page.getCosObject() : PDFCosObject.newCosNull(pdfDoc);
        cosArray.add(cosPage);
        cosArray.addName(PDFPageFit.FitBH.getName());
        PDFDestinationExplicit.addDoubleValue(cosArray, top);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    public static PDFDestinationExplicit newDestFitBV(PDFDocument pdfDoc, PDFPage page, Double left) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(pdfDoc);
        CosObject cosPage = page != null ? page.getCosObject() : PDFCosObject.newCosNull(pdfDoc);
        cosArray.add(cosPage);
        cosArray.addName(PDFPageFit.FitBV.getName());
        PDFDestinationExplicit.addDoubleValue(cosArray, left);
        return PDFDestinationExplicit.getInstance(cosArray);
    }

    private static void addDoubleValue(CosArray destArray, Double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            destArray.add(destArray.getDocument().createCosNull());
        } else {
            destArray.addDouble(value);
        }
    }

    public boolean hasPage() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return false;
        }
        CosObject o = this.getCosArray().get(0);
        return o != null && !(o instanceof CosNumeric);
    }

    @Override
    public PDFPage getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return null;
        }
        CosObject o = this.getCosArray().get(0);
        if (o == null || o instanceof CosNumeric) {
            return null;
        }
        return PDFPage.getInstance(o);
    }

    public void setPage(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosPage = page == null ? this.getCosObject().getDocument().createCosNull() : page.getCosObject();
        this.getCosArray().extendIfNecessaryAndSet(0, cosPage);
    }

    public boolean hasPageNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return false;
        }
        CosObject o = this.getCosArray().get(0);
        return o != null && o instanceof CosNumeric;
    }

    public int getPageNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return -1;
        }
        CosObject o = this.getCosArray().get(0);
        if (!(o instanceof CosNumeric)) {
            return -1;
        }
        return ((CosNumeric)o).intValue();
    }

    public void setPageNumber(int pageNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosArray().extendIfNecessaryAndSet(0, PDFCosObject.newCosNumeric(this.getPDFDocument(), pageNumber));
    }

    @Override
    public PDFPageFit getPageFit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray theArray = this.getCosArray();
        if (theArray == null || theArray.size() < 2) {
            return null;
        }
        if (theArray.get(1).getType() == 3) {
            return PDFPageFit.getInstance(theArray.getName(1));
        }
        return null;
    }

    public void setPageFit(PDFPageFit pageFit) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray array = this.getCosArray();
        CosName o = PDFCosObject.newCosName(this.getPDFDocument(), pageFit);
        array.extendIfNecessaryAndSet(1, o);
    }

    @Override
    public Number[] getCoordinates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null || this.getCosArray().size() < 2) {
            return null;
        }
        int size = this.getCosArray().size() - 2;
        Number[] coords = new Number[size];
        for (int i = 0; i < size; ++i) {
            coords[i] = (Number)this.getCosArray().get(i + 2).getValue();
        }
        return coords;
    }

    public void setCoordinates(Number[] coords) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray array = this.getCosArray();
        for (int i = 0; i < coords.length; ++i) {
            CosNull o = coords[i] == null ? PDFCosObject.newCosNull(this.getPDFDocument()) : PDFCosObject.newCosNumeric(this.getPDFDocument(), coords[i]);
            array.extendIfNecessaryAndSet(i + 2, o);
        }
    }

    @Override
    public ASString getName() {
        return null;
    }
}

