/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFNamedDestinations;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageFit;

public class PDFDestinationNamed
extends PDFDestination {
    private PDFDestinationNamed(CosObject name) throws PDFInvalidDocumentException {
        super(name);
        if (name.getType() != 4 && name.getType() != 3) {
            throw new PDFInvalidDocumentException("Cannot create named destination with non-string name");
        }
    }

    public static PDFDestinationNamed getInstance(CosScalar cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFDestinationNamed pdfObject = (PDFDestinationNamed)PDFCosObject.getCachedInstance(cosObject, PDFDestinationNamed.class);
        if (pdfObject == null) {
            pdfObject = new PDFDestinationNamed(cosObject);
        }
        return pdfObject;
    }

    public static PDFDestinationNamed newInstance(PDFDocument pdfDocument, ASString key, PDFDestinationExplicit dest) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNamedDestinations destTree = pdfDocument.requireCatalog().procureNameDictionary().procureNamedDestinations();
        destTree.addEntry(key, dest);
        CosString destName = PDFCosObject.newCosString(pdfDocument, key.getBytes());
        return new PDFDestinationNamed(destName);
    }

    @Override
    public PDFPage getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDestinationExplicit explicitDest = this.retrieveExplicitDestination();
        return explicitDest != null ? ((PDFDestination)explicitDest).getPage() : null;
    }

    @Override
    public PDFPageFit getPageFit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDestinationExplicit explicitDest = this.retrieveExplicitDestination();
        return explicitDest != null ? ((PDFDestination)explicitDest).getPageFit() : null;
    }

    @Override
    public Number[] getCoordinates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.retrieveExplicitDestination().getCoordinates();
    }

    @Override
    public ASString getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosName = this.getCosObject();
        if (cosName.getType() == 3) {
            return new ASString(cosName.nameValue().getBytes());
        }
        return new ASString((byte[])cosName.getValue());
    }

    public PDFDestinationExplicit getExplicitDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.retrieveExplicitDestination();
    }

    private PDFDestinationExplicit retrieveExplicitDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject name = this.getCosObject();
        if (name.getType() == 3) {
            return (PDFDestinationExplicit)this.get(((CosName)name).nameValue());
        }
        if (name.getType() == 4) {
            PDFNameDictionary nameDict = this.getPDFDocument().requireCatalog().getNameDictionary();
            if (nameDict == null) {
                return null;
            }
            PDFNamedDestinations namedDests = nameDict.getNamedDestinations();
            if (namedDests != null) {
                return (PDFDestinationExplicit)namedDests.getEntry(((CosString)name).stringValue());
            }
        }
        return null;
    }

    public PDFDestination get(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosDest = this.getPDFDocument().requireCatalog().getDictionaryCosObjectValue(ASName.k_Dests);
        if (PDFCosObject.checkNullCosObject(cosDest) == null) {
            return null;
        }
        if (cosDest instanceof CosDictionary) {
            return PDFDestination.getInstance(((CosDictionary)cosDest).get(ASName.k_D));
        }
        return PDFDestination.getInstance(cosDest);
    }

    public boolean delete(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosDests = this.getPDFDocument().requireCatalog().getDictionaryCosObjectValue(ASName.k_Dests);
        if (cosDests == null) {
            return false;
        }
        CosObject cosDest = ((CosDictionary)cosDests).get(name);
        if (cosDest == null) {
            return false;
        }
        if (cosDest instanceof CosDictionary) {
            ((CosDictionary)cosDest).remove(ASName.k_D);
        } else {
            ((CosDictionary)cosDests).remove(name);
        }
        return true;
    }
}

