/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import java.util.ListIterator;

public class PDFNavNode
extends PDFCosDictionary {
    private PDFNavNode(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFNavNode newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFNavNode pdfObject = new PDFNavNode(cosObject);
        pdfObject.setType();
        return pdfObject;
    }

    public static PDFNavNode getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFNavNode pdfObject = (PDFNavNode)PDFCosObject.getCachedInstance(cosObject, PDFNavNode.class);
        if (pdfObject == null) {
            pdfObject = new PDFNavNode(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.create("NavNode"));
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFNavNode getPrevNavNode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNavNode.getInstance(this.getDictionaryCosObjectValue(ASName.k_Prev));
    }

    public void setPrevNavNode(PDFNavNode value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Prev, value);
    }

    public boolean hasPrevNavNode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Prev);
    }

    public PDFNavNode getNextNavNode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNavNode.getInstance(this.getDictionaryCosObjectValue(ASName.k_Next));
    }

    public void setNextNavNode(PDFNavNode value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Next, value);
    }

    public boolean hasNextNavNode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Next);
    }

    public double getDuration() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Dur);
    }

    public void setDuration(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Dur, value);
    }

    public boolean hasDuration() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Dur);
    }

    public PDFAction[] getPA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getActionSequence(ASName.k_PA);
    }

    private PDFAction[] getActionSequence(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAction[] backwardActionsArray = null;
        CosObject cosObj = this.getDictionaryCosObjectValue(key);
        if (cosObj != null) {
            if (cosObj instanceof CosDictionary) {
                backwardActionsArray = new PDFAction[]{PDFActionFactory.getInstance(cosObj)};
            } else if (cosObj instanceof CosArray) {
                backwardActionsArray = new PDFAction[((CosArray)cosObj).size()];
                ListIterator<CosObject> arrIter = ((CosArray)cosObj).listIterator();
                int count = 0;
                while (arrIter.hasNext()) {
                    backwardActionsArray[count++] = PDFActionFactory.getInstance((CosObject)arrIter.next());
                }
            } else {
                throw new PDFInvalidDocumentException("Invalid value for entry " + key.asString() + "  in NavNode dict, invalid Object number " + cosObj.getObjNum());
            }
        }
        return backwardActionsArray;
    }

    public void setPA(PDFAction[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setActionSequence(value, ASName.k_PA);
    }

    public void setNA(PDFAction[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setActionSequence(value, ASName.k_NA);
    }

    public PDFAction[] getNA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getActionSequence(ASName.k_NA);
    }

    private void setActionSequence(PDFAction[] value, ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException {
        if (value == null || value.length == 0) {
            this.removeValue(key);
        } else if (value.length == 1) {
            this.setDictionaryValue(key, value[0]);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < value.length; ++i) {
                cosArray.add(value[i].getCosObject());
            }
            this.setDictionaryValue(key, cosArray);
        }
    }

    public boolean hasBackwardAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PA);
    }

    public boolean hasForwardActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_NA);
    }
}

