/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDimension;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDirectionOfMotion;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFTransitionStyle;

public class PDFTransition
extends PDFCosDictionary {
    private PDFTransition(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFTransition newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFTransition pdfObject = new PDFTransition(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_Trans);
        return pdfObject;
    }

    public static PDFTransition getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFTransition pdfObject = (PDFTransition)PDFCosObject.getCachedInstance(cosObject, PDFTransition.class);
        if (pdfObject == null) {
            pdfObject = new PDFTransition(cosObject);
        }
        return pdfObject;
    }

    public double getStartingScale() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_SS);
    }

    public void setStartingScale(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_SS, value);
    }

    public boolean hasStartingScale() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_SS);
    }

    public int getDirection() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Di);
    }

    public void setDirection(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Di, value);
    }

    public boolean hasDirection() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Di);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public boolean getIsRectangular() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_B);
    }

    public void setIsRectangular(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_B, value);
    }

    public boolean hasIsRectangular() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_B);
    }

    public PDFTransitionStyle getTransitionStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFTransitionStyle.getInstance(this.getDictionaryNameValue(ASName.k_S));
    }

    public void setTransitionStyle(PDFTransitionStyle transitionStyle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (transitionStyle == null) {
            this.removeValue(ASName.k_S);
        } else {
            this.setDictionaryNameValue(ASName.k_S, transitionStyle.getTransitionStyleName());
        }
    }

    public boolean hasStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public PDFDimension getTransitionDimension() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDimension.getInstance(this.getDictionaryNameValue(ASName.k_Dm));
    }

    public void setTransitionDimension(PDFDimension dimension) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (dimension == null) {
            this.removeValue(ASName.k_Dm);
        } else {
            this.setDictionaryNameValue(ASName.k_Dm, dimension.getDimensionName());
        }
    }

    public boolean hasDimension() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Dm);
    }

    public PDFDirectionOfMotion getTransitionDirectionOfMotion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDirectionOfMotion.getInstance(this.getDictionaryNameValue(ASName.k_M));
    }

    public void setTransitionDirectionOfMotion(PDFDirectionOfMotion value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_M);
        } else {
            this.setDictionaryNameValue(ASName.k_M, value.getDirectionOfMotionName());
        }
    }

    public boolean hasDirectionOfMotion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_M);
    }

    public double getDuration() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_D);
    }

    public void setDuration(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_D, value);
    }

    public boolean hasDuration() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_D);
    }
}

