/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;

public class PDFStructureArtifact {
    public static final ASName k_Pagination = ASName.create("Pagination");
    public static final ASName k_Layout = ASName.create("Layout");
    public static final ASName k_Page = ASName.create("Page");
    public static final ASName k_Background = ASName.create("Background");
    public static final ASName k_Header = ASName.create("Header");
    public static final ASName k_Footer = ASName.create("Footer");
    public static final ASName k_Watermark = ASName.create("Watermark");
    public static final ASName k_BatesN = ASName.create("BatesN");
    public static final ASName k_Artifact = ASName.create("Artifact");
    private final ASName mType;
    private final ASName mSubtype;
    private final PDFRectangle mRect;
    private final ASName[] mPosition;
    private final ASString[] mContents;

    private PDFStructureArtifact(ASName type, ASName subtype, PDFRectangle rect, ASName[] location, ASString[] batesNumber) {
        this.mType = type;
        this.mSubtype = subtype;
        this.mRect = rect;
        this.mPosition = location;
        this.mContents = batesNumber;
    }

    public static PDFStructureArtifact newPaginationArtifact(PDFDocument pdfDoc, ASName subtype, PDFRectangle rect, ASName[] location) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFVersion version = pdfDoc.procureToSaveVersion();
        if (version.lessThan(PDFVersion.v1_7)) {
            subtype = null;
        }
        return new PDFStructureArtifact(k_Pagination, subtype, rect, location, null);
    }

    public static PDFStructureArtifact newPageArtifact(PDFDocument pdfDoc, PDFRectangle rect, ASName[] location) {
        return new PDFStructureArtifact(k_Page, null, rect, location, null);
    }

    public static PDFStructureArtifact newLayoutArtifact(PDFDocument pdfDoc, PDFRectangle rect, ASName[] location) {
        return new PDFStructureArtifact(k_Layout, null, rect, location, null);
    }

    public static PDFStructureArtifact newBackgroundArtifact(PDFDocument pdfDoc, PDFRectangle rect, ASName[] location) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (pdfDoc.procureToSaveVersion().lessThan(PDFVersion.v1_7)) {
            return null;
        }
        return new PDFStructureArtifact(k_Background, null, rect, location, null);
    }

    public static PDFStructureArtifact newPaginationArtifactBatesNumber(PDFRectangle rect, ASName[] location, ASString[] batesNumber) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return new PDFStructureArtifact(k_Pagination, ASName.k_BatesN, rect, location, batesNumber);
    }

    public ASString[] getContents() {
        return this.mContents;
    }

    public ASName getType() {
        return this.mType;
    }

    public ASName getSubtype() {
        return this.mSubtype;
    }

    public PDFRectangle getBBox() {
        return this.mRect;
    }

    public ASName[] getPosition() {
        return this.mPosition;
    }
}

