/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentFactory;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentIterator;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.util.Iterator;

public class PDFStructureContentArray
extends PDFCosArrayList<PDFStructureContentInterface>
implements PDFStructureContentInterface {
    private PDFStructureContentArray(CosObject item) throws PDFInvalidDocumentException {
        super(item);
    }

    @Override
    public PDFPage getPage() {
        return null;
    }

    public static PDFStructureContentArray getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureContentArray pdfObject = (PDFStructureContentArray)PDFCosObject.getCachedInstance(cosObject, PDFStructureContentArray.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureContentArray(cosObject);
        }
        return pdfObject;
    }

    public static PDFStructureContentArray newInstance(PDFDocument pdfDoc, PDFStructureContentInterface firstContent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureContentArray arrayContent = PDFStructureContentArray.getInstance(PDFCosObject.newCosArray(pdfDoc));
        if (firstContent != null) {
            arrayContent.addContent(firstContent);
        }
        return arrayContent;
    }

    @Override
    protected PDFStructureContentInterface itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFStructureContentFactory.getInstance(cosObject);
    }

    @Override
    public void addContent(PDFStructureContentInterface item) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super.add(item);
    }

    private Iterator getIterator() {
        return this.getCosArray().iterator();
    }

    @Override
    public PDFStructureContentIterator contentIterator() {
        return new PDFStructureArrayIterator(this);
    }

    @Override
    public PDFStructureType getStructureType() {
        return PDFStructureType.Array;
    }

    static class PDFStructureArrayIterator
    extends PDFStructureContentIterator {
        private final Iterator arrayIterator;

        PDFStructureArrayIterator(PDFStructureContentArray node) {
            super(node);
            this.arrayIterator = node.getIterator();
        }

        @Override
        public boolean hasNext() {
            return this.arrayIterator.hasNext();
        }

        @Override
        public PDFStructureContentInterface next() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return PDFStructureContentFactory.getInstance((CosObject)this.arrayIterator.next());
        }

        @Override
        public void remove() {
            this.arrayIterator.remove();
        }

        @Override
        public boolean isScalar() {
            return false;
        }
    }
}

