/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentIterator;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureOBJR;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureParentTree;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRole;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;

public class PDFStructureUtils {
    public static PDFStructureRole getRole(PDFStructureElement structElement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureRoot structRoot = structElement.getPDFDocument().requireCatalog().getStructureRoot();
        PDFStructureRoleMap roleMap = structRoot.getRoleMap();
        ASName role = null;
        if (roleMap != null) {
            role = roleMap.getRole(structElement.requireStructureType());
        }
        if (role == null) {
            return PDFStructureRole.getRole(structElement.requireStructureType());
        }
        return PDFStructureRole.getRole(role);
    }

    public static void removeOBJReference(PDFCosDictionary refDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFStructureElement parentStructElement = PDFStructureUtils.getStructParentElement(refDict);
        if (parentStructElement == null) {
            return;
        }
        PDFStructureContentInterface parentContent = parentStructElement.getContent();
        if (parentContent == null) {
            return;
        }
        PDFStructureContentIterator contentIter = parentContent.contentIterator();
        while (contentIter.hasNext()) {
            PDFStructureParentTree parentTree;
            PDFStructureContentInterface curContent = contentIter.next();
            if (!curContent.getStructureType().contains(PDFStructureType.OBJR) || refDict.getCosObject() != ((PDFStructureOBJR)curContent).getDictionaryValue(ASName.k_Obj)) continue;
            if (contentIter.isScalar()) {
                parentStructElement.removeKids();
            } else {
                contentIter.remove();
            }
            PDFStructureRoot structRoot = refDict.getPDFDocument().requireCatalog().getStructureRoot();
            PDFStructureParentTree pDFStructureParentTree = parentTree = structRoot == null ? null : structRoot.getParentTree();
            if (parentTree == null) break;
            parentTree.removeEntry(PDFStructureUtils.getStructParent(refDict));
            break;
        }
    }

    public static void replaceOBJR(PDFCosDictionary newRef, PDFCosDictionary oldRef) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFStructureUtils.hasStructParent(oldRef)) {
            int structParent = PDFStructureUtils.getStructParent(oldRef);
            PDFStructureElement parentElement = PDFStructureUtils.getStructParentElement(oldRef);
            if (parentElement != null) {
                PDFStructureContentInterface parentContent = parentElement.getContent();
                PDFStructureContentIterator contentIter = parentContent.contentIterator();
                while (contentIter.hasNext()) {
                    PDFStructureOBJR objrContent;
                    PDFStructureContentInterface curContent = contentIter.next();
                    if (!curContent.getStructureType().contains(PDFStructureType.OBJR) || !(objrContent = (PDFStructureOBJR)curContent).containsOBJ(oldRef)) continue;
                    oldRef.removeValue(ASName.k_StructParent);
                    PDFStructureUtils.setStructParent(structParent, newRef);
                    objrContent.setOBJR(newRef);
                }
            }
        }
    }

    public static PDFStructureNode getNode(CosDictionary node) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName type = null;
        if (node.containsKey(ASName.k_Type)) {
            type = node.getName(ASName.k_Type);
        }
        if (type != null && type.equals(ASName.k_StructTreeRoot)) {
            return PDFStructureRoot.getInstance(node);
        }
        return PDFStructureElement.getInstance(node);
    }

    public static PDFStructureContentArray getStructParentArray(PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureParentTree parentTree;
        if (!PDFStructureUtils.hasStructParents(dict)) {
            return null;
        }
        PDFStructureRoot structRoot = dict.getPDFDocument().requireCatalog().getStructureRoot();
        PDFStructureParentTree pDFStructureParentTree = parentTree = structRoot == null ? null : structRoot.getParentTree();
        if (parentTree == null) {
            return null;
        }
        PDFStructureContentInterface parentArray = (PDFStructureContentInterface)parentTree.getEntry(PDFStructureUtils.getStructParents(dict));
        if (parentArray == null) {
            return null;
        }
        if (!(parentArray instanceof PDFStructureContentArray)) {
            throw new PDFInvalidDocumentException("Expected PDFStructureContentArray");
        }
        return (PDFStructureContentArray)parentArray;
    }

    public static int getStructParent(PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return dict.getDictionaryIntValue(ASName.k_StructParent);
    }

    public static void setStructParent(int structParent, PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        dict.setDictionaryIntValue(ASName.k_StructParent, structParent);
    }

    public static boolean hasStructParent(PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean result = false;
        if (dict.dictionaryContains(ASName.k_StructParent)) {
            result = true;
        }
        return result;
    }

    public static Integer getStructParents(PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return dict.getDictionaryIntValue(ASName.k_StructParents);
    }

    public static void setStructParents(Integer structParents, PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (structParents == null) {
            dict.removeValue(ASName.k_StructParents);
        } else {
            dict.setDictionaryIntValue(ASName.k_StructParents, structParents.intValue());
        }
    }

    public static boolean hasStructParents(PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean result = false;
        if (dict.dictionaryContains(ASName.k_StructParents)) {
            result = true;
        }
        return result;
    }

    public static PDFStructureElement getStructParentElement(PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureParentTree parentTree;
        if (!PDFStructureUtils.hasStructParent(dict)) {
            return null;
        }
        PDFStructureRoot structRoot = dict.getPDFDocument().requireCatalog().getStructureRoot();
        PDFStructureParentTree pDFStructureParentTree = parentTree = structRoot == null ? null : structRoot.getParentTree();
        if (parentTree == null) {
            return null;
        }
        PDFStructureContentInterface parentElement = (PDFStructureContentInterface)parentTree.getEntry(PDFStructureUtils.getStructParent(dict));
        if (parentElement == null) {
            return null;
        }
        if (!(parentElement instanceof PDFStructureElement)) {
            throw new PDFInvalidDocumentException("Expected PDFStructureElement");
        }
        return (PDFStructureElement)parentElement;
    }

    private static int setStructParents(PDFStructureContentInterface structParents, PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFStructureRoot structRoot = dict.getPDFDocument().requireCatalog().getStructureRoot();
        if (structRoot == null) {
            return -1;
        }
        PDFStructureParentTree parentTree = structRoot.procureParentTree();
        int key = structRoot.getNextParentKey();
        parentTree.addEntry(key, structParents);
        structRoot.setNextParentKey(key + 1);
        return key;
    }

    public static void setStructParentsInTree(PDFStructureContentArray structParents, PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFStructureUtils.setStructParents(PDFStructureUtils.setStructParents(structParents, dict), dict);
    }

    public static void setStructParentInTree(PDFStructureElement structParent, PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFStructureUtils.setStructParents(PDFStructureUtils.setStructParents(structParent, dict), dict);
    }
}

