/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDF3DADict
extends PDFCosDictionary {
    private PDF3DADict(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DADict newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDF3DADict(cosObject);
    }

    public static PDF3DADict getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DADict pdfObject = (PDF3DADict)PDFCosObject.getCachedInstance(cosObject, PDF3DADict.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DADict(cosObject);
        }
        return pdfObject;
    }

    public boolean getNP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_NP);
    }

    public void setNP(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_NP, value);
    }

    public boolean hasNP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_NP);
    }

    public ASName getDeactivationInstantState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_DIS);
    }

    public void setDeactivationInstantState(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_DIS);
        } else if (value.equals(ASName.k_L) || value.equals(ASName.k_I) || value.equals(ASName.k_U)) {
            this.setDictionaryNameValue(ASName.k_DIS, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for DeactivationInstantState.");
        }
    }

    public boolean hasDeactivationInstantState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_DIS);
    }

    public boolean getToolbar() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_TB);
    }

    public void setToolbar(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_TB, value);
    }

    public boolean hasToolbar() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TB);
    }

    public ASName getActivation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_A);
    }

    public void setActivation(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_A);
        } else if (value.equals(ASName.k_PO) || value.equals(ASName.k_PV) || value.equals(ASName.k_XA)) {
            this.setDictionaryNameValue(ASName.k_A, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Activation.");
        }
    }

    public boolean hasActivation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_A);
    }

    public ASName getDeactivation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_D);
    }

    public void setDeactivation(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_D);
        } else if (value.equals(ASName.k_PC) || value.equals(ASName.k_PI) || value.equals(ASName.k_XD)) {
            this.setDictionaryNameValue(ASName.k_D, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Deactivation.");
        }
    }

    public boolean hasDeactivation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_D);
    }

    public ASName getArtworkInstaciationState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_AIS);
    }

    public void setArtworkInstaciationState(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_AIS);
        } else if (value.equals(ASName.k_I) || value.equals(ASName.k_L)) {
            this.setDictionaryNameValue(ASName.k_AIS, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for ArtworkInstaciationState.");
        }
    }

    public boolean hasArtworkInstaciationState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_AIS);
    }
}

