/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DANDict;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVDict;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DViewArray;

public class PDF3DDStream
extends PDFCosStream {
    public static final ASName k_U3D = ASName.create("U3D");
    public static final ASName k_PRC = ASName.create("PRC");

    private PDF3DDStream(CosObject cosStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosStream);
    }

    public static PDF3DDStream newInstance(PDFDocument pdfDocument, ASName key_Subtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Subtype == null) {
            throw new PDFInvalidParameterException("Subtype is required when creating newInstance of PDF3DDStream.");
        }
        CosStream cosObject = PDFCosObject.newCosStream(pdfDocument);
        PDF3DDStream pdfObject = new PDF3DDStream(cosObject);
        pdfObject.setType();
        pdfObject.setSubtype(key_Subtype);
        return pdfObject;
    }

    public static PDF3DDStream getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DDStream pdfObject = (PDF3DDStream)PDFCosObject.getCachedInstance(cosObject, PDF3DDStream.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DDStream(cosObject);
        }
        return pdfObject;
    }

    public PDFStream getOnInstantiate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStream.getInstance(this.getDictionaryCosObjectValue(ASName.k_OnInstantiate));
    }

    public void setOnInstantiate(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_OnInstantiate, value);
    }

    public PDFStream procureOnInstantiate() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasOnInstantiate()) {
            return PDFStream.newInstance(this.getPDFDocument());
        }
        return this.getOnInstantiate();
    }

    public boolean hasOnInstantiate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_OnInstantiate);
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_3D);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDF3DViewArray getPresetViewArtwork() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(ASName.k_VA);
        return PDF3DViewArray.getInstance(cosObject);
    }

    public void setPresetViewArtwork(PDF3DViewArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_VA, value);
    }

    public boolean hasPresetViewArtwork() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_VA);
    }

    @Override
    public void setSubtype(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Subtype is a required key therefore cannot be removed.");
        }
        if (!value.equals(k_U3D) && !value.equals(k_PRC)) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Subtype.");
        }
        this.setDictionaryNameValue(ASName.k_Subtype, value);
    }

    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_Subtype);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Subtype);
    }

    public PDF3DANDict getAN() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DANDict.getInstance(this.getDictionaryCosObjectValue(ASName.k_AN));
    }

    public void setAN(PDF3DANDict value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_AN, value);
    }

    public boolean hasAN() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_AN);
    }

    public PDFResources getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFResources.getInstance(this.getDictionaryCosObjectValue(ASName.k_Resources));
    }

    public void setResources(PDFResources value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Resources, value);
    }

    public boolean hasResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Resources);
    }

    public int getDefaultViewAsInteger() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_DV);
    }

    public void setDefaultView(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_DV, value);
    }

    public ASString getDefaultViewAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_DV);
    }

    public void setDefaultView(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_DV, value);
    }

    public void setDefaultView(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_DV, value);
    }

    public ASName getDefaultViewAsName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_DV);
    }

    public void setDefaultView(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryNameValue(ASName.k_DV, value);
    }

    public PDF3DVDict getDefaultViewAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DVDict.getInstance(this.getDictionaryCosObjectValue(ASName.k_DV));
    }

    public void setDefaultView(PDF3DVDict value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_DV, value);
    }

    public boolean hasDefaultView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_DV);
    }
}

