/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DLightingScheme;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementList;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DNodeArray;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DRenderMode;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DSectionArray;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVBGDict;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVPDict;

public class PDF3DVDict
extends PDFCosDictionary {
    public static final ASName k_MA = ASName.create("MA");
    public static final ASName k_M = ASName.create("M");
    public static final ASName k_U3D = ASName.create("U3D");

    protected PDF3DVDict(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DVDict newInstance(PDFDocument pdfDocument, ASString key_ExternalName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_ExternalName == null) {
            throw new PDFInvalidParameterException("ExternalName is required when creating newInstance of PDF3DVDict.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDF3DVDict pdfObject = new PDF3DVDict(cosObject);
        pdfObject.setExternalName(key_ExternalName);
        pdfObject.setType(ASName.k_3DView);
        return pdfObject;
    }

    public static PDF3DVDict getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DVDict pdfObject = (PDF3DVDict)PDFCosObject.getCachedInstance(cosObject, PDF3DVDict.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DVDict(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.k_3DView)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Type.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public double getCenterOfOrbit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_CO);
    }

    public void setCenterOfOrbit(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_CO, value);
    }

    public boolean hasCenterOfOrbit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CO);
    }

    public PDFXObjectForm getO() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXObjectForm.getInstance(this.getDictionaryCosObjectValue(ASName.k_O));
    }

    public void setO(PDFXObjectForm value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_O, value);
    }

    public boolean hasO() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_O);
    }

    public PDF3DRenderMode getRM() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DRenderMode.getInstance(this.getDictionaryCosObjectValue(ASName.k_RM));
    }

    public void setRM(PDF3DRenderMode value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_RM, value);
    }

    public boolean hasRM() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_RM);
    }

    public ASString getU3DPathAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_U3DPath);
    }

    public void setU3DPath(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_U3DPath, value);
    }

    public void setU3DPath(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_U3DPath, value);
    }

    public CosArray getU3DPathAsArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_U3DPath);
    }

    public void setU3DPath(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_U3DPath, value);
    }

    public boolean hasU3DPath() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_U3DPath);
    }

    public PDF3DVPDict getP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DVPDict.getInstance(this.getDictionaryCosObjectValue(ASName.k_P));
    }

    public void setP(PDF3DVPDict value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_P, value);
    }

    public boolean hasP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_P);
    }

    public PDF3DLightingScheme getLS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DLightingScheme.getInstance(this.getDictionaryCosObjectValue(ASName.k_LS));
    }

    public void setLS(PDF3DLightingScheme value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_LS, value);
    }

    public boolean hasLS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_LS);
    }

    public double[] getCameraToWorld() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(ASName.k_C2W);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble();
    }

    public void setCameraToWorld(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_C2W, value);
    }

    public boolean hasCameraToWorld() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_C2W);
    }

    public PDF3DSectionArray getSA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DSectionArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_SA));
    }

    public void setSA(PDF3DSectionArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_SA, children.getCosArray());
    }

    public boolean hasSA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_SA);
    }

    public ASName getMatrixSource() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_MS);
    }

    public void setMatrixSource(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_MS);
        } else if (value.equals(k_M) || value.equals(k_U3D)) {
            this.setDictionaryNameValue(ASName.k_MS, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for MatrixSource.");
        }
    }

    public boolean hasMatrixSource() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MS);
    }

    public boolean getNAReturned() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_NR);
        if (cosObject instanceof CosBoolean) {
            return ((CosBoolean)cosObject).booleanValue();
        }
        return false;
    }

    public void setNAReturned(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_NR, value);
    }

    public boolean hasNAReturned() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_NR);
    }

    public PDF3DNodeArray getNA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DNodeArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_NA));
    }

    public void setNA(PDF3DNodeArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_NA, children.getCosArray());
    }

    public boolean hasNA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_NA);
    }

    public ASString getExternalName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_XN);
    }

    public void setExternalName(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("ExternalName is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_XN, value);
    }

    public void setExternalName(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("ExternalName is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_XN, value);
    }

    public ASString requireExternalName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString name = this.getDictionaryStringValue(ASName.k_XN);
        if (name == null) {
            throw new PDFInvalidDocumentException("Could not get ExternalName");
        }
        return name;
    }

    public boolean hasExternalName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_XN);
    }

    public ASString getInternalName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_IN);
    }

    public void setInternalName(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_IN, value);
    }

    public void setInternalName(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_IN, value);
    }

    public boolean hasInternalName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_IN);
    }

    public PDF3DVBGDict getBG() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DVBGDict.getInstance(this.getDictionaryCosObjectValue(ASName.k_BG));
    }

    public void setBG(PDF3DVBGDict value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_BG, value);
    }

    public boolean hasBG() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BG);
    }

    public PDF3DMeasurementList getMA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_MA);
        return PDF3DMeasurementList.getInstance(cosObject);
    }

    public void setMA(PDF3DMeasurementList value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_MA, value);
    }

    public boolean hasMA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_MA);
    }
}

