/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFCuePoint;

public class PDFCuePointList
extends PDFCosArrayList<PDFCuePoint> {
    private PDFCuePointList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCuePointList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCuePointList pdfObject = (PDFCuePointList)PDFCosObject.getCachedInstance(cosObject, PDFCuePointList.class);
        if (pdfObject == null) {
            pdfObject = new PDFCuePointList(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFCuePoint itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCuePoint.getInstance(cosObject);
    }

    public static PDFCuePointList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFCuePointList pdfObject = new PDFCuePointList(cosObject);
        return pdfObject;
    }

    public static PDFCuePointList newInstance(PDFDocument pdfDocument, PDFCuePointList configs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (configs.size() > 0) {
            CosArray cosObject = PDFCosObject.makeCosArray(pdfDocument, configs);
            return PDFCuePointList.getInstance(cosObject);
        }
        return PDFCuePointList.newInstance(pdfDocument);
    }
}

