/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaOffsetFrame;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaOffsetMarker;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaOffsetTime;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaOffsetUnknown;

public abstract class PDFMediaOffset
extends PDFCosDictionary {
    protected PDFMediaOffset(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMediaOffset getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("CosDictionary expected");
        }
        ASName nameSubtype = ((CosDictionary)cosObject).getName(ASName.k_Subtype);
        if (nameSubtype == null) {
            throw new PDFInvalidDocumentException("Unknown type.");
        }
        if (nameSubtype == ASName.k_T) {
            return PDFMediaOffsetTime.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_F) {
            return PDFMediaOffsetFrame.getInstance(cosObject);
        }
        if (nameSubtype == ASName.k_M) {
            return PDFMediaOffsetMarker.getInstance(cosObject);
        }
        return PDFMediaOffsetUnknown.getInstance(cosObject);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public void setSubtype(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Subtype is a required key therefore cannot be removed.");
        }
        if (!(value.equals(ASName.k_T) || value.equals(ASName.k_F) || value.equals(ASName.k_M))) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Subtype.");
        }
        this.setDictionaryNameValue(ASName.k_S, value);
    }

    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_S);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }
}

