/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFBestEffortMediaPlayParams;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaPlayers;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMustHonorMediaPlayParams;

public class PDFMediaPlayParams
extends PDFCosDictionary {
    private PDFMediaPlayParams(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMediaPlayParams newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMediaPlayParams pdfObject = new PDFMediaPlayParams(cosObject);
        pdfObject.setType();
        return pdfObject;
    }

    public static PDFMediaPlayParams getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMediaPlayParams pdfObject = (PDFMediaPlayParams)PDFCosObject.getCachedInstance(cosObject, PDFMediaPlayParams.class);
        if (pdfObject == null) {
            pdfObject = new PDFMediaPlayParams(cosObject);
        }
        return pdfObject;
    }

    public PDFMediaPlayers getPL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaPlayers.getInstance(this.getDictionaryCosObjectValue(ASName.k_PL));
    }

    public void setPL(PDFMediaPlayers value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_PL, value);
    }

    public boolean hasPL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PL);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_MediaPlayParams);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFBestEffortMediaPlayParams getBE() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBestEffortMediaPlayParams.getInstance(this.getDictionaryCosObjectValue(ASName.k_BE));
    }

    public void setBE(PDFBestEffortMediaPlayParams value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_BE, value);
    }

    public boolean hasBE() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BE);
    }

    public PDFMustHonorMediaPlayParams getMH() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMustHonorMediaPlayParams.getInstance(this.getDictionaryCosObjectValue(ASName.k_MH));
    }

    public void setMH(PDFMustHonorMediaPlayParams value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_MH, value);
    }

    public boolean hasMH() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MH);
    }
}

