/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFRichMediaPosition
extends PDFCosDictionary {
    private PDFRichMediaPosition(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaPosition newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaPosition pdfObject = new PDFRichMediaPosition(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaPosition getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaPosition pdfObject = (PDFRichMediaPosition)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaPosition.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaPosition(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.k_RichMediaPosition)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidDocumentException("Type value is not valid. " + ASName.k_RichMediaPosition + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getHAlign() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_HAlign);
    }

    public void setHAlign(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.removeValue(ASName.k_HAlign);
        } else if (value.equals(ASName.k_Near) || value.equals(ASName.k_Center) || value.equals(ASName.k_Far)) {
            this.setDictionaryNameValue(ASName.k_HAlign, value);
        } else {
            throw new PDFInvalidDocumentException("HAlign value is not valid. Near, Center or Far is expected.");
        }
    }

    public boolean hasHAlign() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_HAlign);
    }

    public ASName getVAlign() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_VAlign);
    }

    public void setVAlign(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.removeValue(ASName.k_VAlign);
        } else if (value.equals(ASName.k_Near) || value.equals(ASName.k_Center) || value.equals(ASName.k_Far)) {
            this.setDictionaryNameValue(ASName.k_VAlign, value);
        } else {
            throw new PDFInvalidDocumentException("VAlign value is not valid. Near, Center or Far is expected.");
        }
    }

    public boolean hasVAlign() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_VAlign);
    }

    public double getHOffset() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_HOffset);
    }

    public void setHOffset(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_HOffset, value);
    }

    public boolean hasHOffset() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_HOffset);
    }

    public double getVOffset() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_VOffset);
    }

    public void setVOffset(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_VOffset, value);
    }

    public boolean hasVOffset() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_VOffset);
    }
}

