/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaActivation;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaDeactivation;

public class PDFRichMediaSettings
extends PDFCosDictionary {
    public static final ASName k_RichMediaSettings = ASName.create("RichMediaSettings");
    public static final ASName k_Activation = ASName.create("Activation");
    public static final ASName k_Deactivation = ASName.create("Deactivation");

    private PDFRichMediaSettings(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaSettings newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaSettings pdfObject = new PDFRichMediaSettings(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaSettings getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaSettings pdfObject = (PDFRichMediaSettings)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaSettings.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaSettings(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(k_RichMediaSettings)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Type value is not valid. " + k_RichMediaSettings + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFRichMediaActivation getActivation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaActivation.getInstance(this.getDictionaryCosObjectValue(k_Activation));
    }

    public void setActivation(PDFRichMediaActivation value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Activation, value);
    }

    public boolean hasActivation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Activation);
    }

    public PDFRichMediaDeactivation getDeactivation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaDeactivation.getInstance(this.getDictionaryCosObjectValue(k_Deactivation));
    }

    public void setDeactivation(PDFRichMediaDeactivation value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Deactivation, value);
    }

    public boolean hasDeactivation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Deactivation);
    }
}

