/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class PDFTemplate
extends PDFPage {
    private static final ASName k_Template = ASName.create("Template");

    private PDFTemplate(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFTemplate getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFTemplate pdfObject = (PDFTemplate)PDFCosObject.getCachedInstance(cosObject, PDFTemplate.class);
        if (pdfObject == null) {
            pdfObject = new PDFTemplate(cosObject);
        }
        return pdfObject;
    }

    public static PDFPage newInstance(PDFDocument pdfDocument, PDFRectangle mediaBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosPage = PDFCosObject.newCosDictionary(pdfDocument);
        cosPage.put(ASName.k_Type, k_Template);
        cosPage.put(ASName.k_MediaBox, mediaBox.getCosObject());
        return new PDFTemplate(cosPage);
    }

    public boolean isVisible() {
        return false;
    }

    public void setVisisble(boolean visible) {
    }

    public String getName() {
        return null;
    }

    public void setName(String name) {
    }
}

