/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interchange.PDFApplicationData;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureClassMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPagePiece;

public class PDFWPPageInfo
extends PDFCosDictionary {
    public static final ASName k_PDFWP = ASName.create("PDFWP");
    public static final ASName k_MasterPage = ASName.create("MasterPage");

    private PDFWPPageInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFWPPageInfo getInstance(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPagePiece pageInfo = page.getPieceInfo();
        if (pageInfo == null) {
            return null;
        }
        PDFApplicationData pieceInfo = pageInfo.getApplicationData(k_PDFWP);
        if (pieceInfo == null) {
            return null;
        }
        return new PDFWPPageInfo(pieceInfo.getPrivateData());
    }

    public static PDFWPPageInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return new PDFWPPageInfo(cosObject);
    }

    public static PDFWPPageInfo newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFWPPageInfo(cosObject);
    }

    public PDFStructureClassMap getClassMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureClassMap.getInstance(this.getDictionaryValue(ASName.k_ClassMap));
    }

    public void setClassMap(PDFStructureClassMap classMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ClassMap, classMap);
    }

    public String getMasterPageName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_MasterPage);
    }

    public void setMasterPageName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_MasterPage, name);
    }

    public void setMasterPageName(String name, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_MasterPage, name, unicode);
    }

    public PDFApplicationData setPageInfo(PDFPage page, PDFPage srcPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPagePiece pageInfo = page.procurePieceInfo();
        PDFApplicationData appData = PDFApplicationData.newInstance(page.getPDFDocument());
        appData.setPrivateData(this);
        ASDate modDate = srcPage.getPieceInfo().getApplicationData(k_PDFWP).getLastModified();
        if (modDate != null) {
            appData.setLastModified(modDate);
        }
        pageInfo.setApplicationData(k_PDFWP, appData);
        page.setPieceInfo(pageInfo);
        return appData;
    }
}

