/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.rendering;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionFactory;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftone;

public abstract class PDFHalftoneWithFunction
extends PDFHalftone {
    protected PDFHalftoneWithFunction(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public boolean isTranferFunctionName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryCosObjectValue(ASName.k_TransferFunction) instanceof CosName;
    }

    public boolean isTranferFunctionDictionary() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryCosObjectValue(ASName.k_TransferFunction) instanceof CosDictionary;
    }

    public ASName getTransferFunctionAsName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_TransferFunction);
    }

    public void setTransferFunction(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryNameValue(ASName.k_TransferFunction, value);
    }

    public PDFFunction getTransferFunctionAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFunctionFactory.getInstance(this.getDictionaryCosObjectValue(ASName.k_TransferFunction));
    }

    public void setTransferFunction(PDFFunction value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_TransferFunction, value);
    }

    public PDFStream getTransferFunctionAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(ASName.k_TransferFunction);
        return PDFStream.getInstance(cosObject);
    }

    public void setTransferFunction(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_TransferFunction, value);
    }

    public boolean hasTransferFunction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TransferFunction);
    }
}

