/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.transparency;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;

public class PDFXObjectImageSoftMask
extends PDFXObjectImage {
    private PDFXObjectImageSoftMask(CosObject cosStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosStream);
    }

    public static PDFXObjectImageSoftMask newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosStream cosStream = PDFCosObject.newCosStream(pdfDocument);
        PDFXObjectImageSoftMask pdfObject = new PDFXObjectImageSoftMask(cosStream);
        pdfObject.setColorSpace();
        pdfObject.setSubtype();
        pdfObject.setImageMask();
        pdfObject.addFlateFilter();
        return pdfObject;
    }

    public static PDFXObjectImageSoftMask newInstance(PDFDocument pdfDocument, int key_BitsPerComponent, int key_Width, int key_Height) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectImageSoftMask pdfObject = PDFXObjectImageSoftMask.newInstance(pdfDocument);
        pdfObject.setBitsPerComponent(key_BitsPerComponent);
        pdfObject.setWidth(key_Width);
        pdfObject.setHeight(key_Height);
        return pdfObject;
    }

    public static PDFXObjectImageSoftMask getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFXObjectImageSoftMask pdfObject = (PDFXObjectImageSoftMask)PDFCosObject.getCachedInstance(cosObject, PDFXObjectImageSoftMask.class);
        if (pdfObject == null) {
            pdfObject = new PDFXObjectImageSoftMask(cosObject);
        }
        return pdfObject;
    }

    public boolean getImageMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_ImageMask);
    }

    protected void setImageMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_ImageMask, false);
    }

    public boolean hasImageMask() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ImageMask);
    }

    protected void setSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Subtype, ASName.create("Image"));
    }

    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_Subtype);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Subtype);
    }

    @Override
    public int getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Width);
    }

    @Override
    public void setWidth(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Width, value);
    }

    public int requireWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Width);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get Width.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Width);
    }

    public boolean getInterpolate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Interpolate);
    }

    public void setInterpolate(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Interpolate, value);
    }

    public boolean hasInterpolate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Interpolate);
    }

    @Override
    public int getHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Height);
    }

    @Override
    public void setHeight(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Height, value);
    }

    public int requireHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Height);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get Height.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Height);
    }

    public void setDecode(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Decode, value);
    }

    public boolean hasDecode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Decode);
    }

    @Override
    public int getBitsPerComponent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_BitsPerComponent);
    }

    @Override
    public void setBitsPerComponent(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_BitsPerComponent, value);
    }

    public int requireBitsPerComponent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_BitsPerComponent);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get BitsPerComponent.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasBitsPerComponent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BitsPerComponent);
    }

    public CosArray getMatte() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Matte);
    }

    public void setMatte(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Matte, value);
    }

    public boolean hasMatte() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Matte);
    }

    public void setColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_ColorSpace, ASName.k_DeviceGray);
    }

    public ASName requireColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_ColorSpace);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get ColorSpace.");
        }
        return name;
    }

    public boolean hasColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ColorSpace);
    }
}

