/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.BitsPerComponentBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ComponentMappingBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CrossReferenceBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ImageHeaderBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.IntellectualPropertyBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.LabelBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.PaletteBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ROIDescriptionBox;
import java.io.IOException;

public class CodestreamHeaderBox
extends Jpeg2000Box {
    private LabelBox labelBox;
    private ImageHeaderBox imageHeaderBox;
    private BitsPerComponentBox bitsPerComponentBox;
    private PaletteBox paletteBox;
    private ComponentMappingBox componentMappingBox;
    private ROIDescriptionBox roiDescriptionBox;
    private IntellectualPropertyBox intellectualPropertyBox;
    private CrossReferenceBox crossReferenceBox;

    CodestreamHeaderBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public LabelBox getLabelBox() throws IOException {
        this.lazilyPopulateFields();
        return this.labelBox;
    }

    public ImageHeaderBox getImageHeaderBox() throws IOException {
        this.lazilyPopulateFields();
        return this.imageHeaderBox;
    }

    public BitsPerComponentBox getBitsPerComponentBox() throws IOException {
        this.lazilyPopulateFields();
        return this.bitsPerComponentBox;
    }

    public PaletteBox getPaletteBox() throws IOException {
        this.lazilyPopulateFields();
        return this.paletteBox;
    }

    public ComponentMappingBox getComponentMappingBox() throws IOException {
        this.lazilyPopulateFields();
        return this.componentMappingBox;
    }

    public ROIDescriptionBox getROIDescriptionBox() throws IOException {
        this.lazilyPopulateFields();
        return this.roiDescriptionBox;
    }

    public IntellectualPropertyBox getIntellectualPropertyBox() throws IOException {
        this.lazilyPopulateFields();
        return this.intellectualPropertyBox;
    }

    public CrossReferenceBox getCrossReferenceBox() throws IOException {
        this.lazilyPopulateFields();
        return this.crossReferenceBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            block13: while (boxContents.bytesAvailable() > 0L) {
                Jpeg2000BoxInfo innerBoxInfo = new Jpeg2000BoxInfo(boxContents);
                Jpeg2000BoxType innerBoxType = innerBoxInfo.getType();
                if (innerBoxType == null) continue;
                switch (innerBoxType) {
                    case labelBox: {
                        this.labelBox = new LabelBox(innerBoxInfo);
                        continue block13;
                    }
                    case imageHeaderBox: {
                        this.imageHeaderBox = new ImageHeaderBox(innerBoxInfo);
                        continue block13;
                    }
                    case bitsPerComponentBox: {
                        this.bitsPerComponentBox = new BitsPerComponentBox(innerBoxInfo);
                        continue block13;
                    }
                    case paletteBox: {
                        this.paletteBox = new PaletteBox(innerBoxInfo);
                        continue block13;
                    }
                    case componentMappingBox: {
                        this.componentMappingBox = new ComponentMappingBox(innerBoxInfo);
                        continue block13;
                    }
                    case roiDescriptionBox: {
                        this.roiDescriptionBox = new ROIDescriptionBox(innerBoxInfo);
                        continue block13;
                    }
                    case intellectualPropertyBox: {
                        this.intellectualPropertyBox = new IntellectualPropertyBox(innerBoxInfo);
                        continue block13;
                    }
                    case crossReferenceBox: {
                        this.crossReferenceBox = new CrossReferenceBox(innerBoxInfo);
                        continue block13;
                    }
                }
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            if (this.labelBox != null) {
                this.labelBox.close();
            }
        }
        finally {
            try {
                if (this.imageHeaderBox != null) {
                    this.imageHeaderBox.close();
                }
            }
            finally {
                try {
                    if (this.bitsPerComponentBox != null) {
                        this.bitsPerComponentBox.close();
                    }
                }
                finally {
                    try {
                        if (this.paletteBox != null) {
                            this.paletteBox.close();
                        }
                    }
                    finally {
                        try {
                            if (this.componentMappingBox != null) {
                                this.componentMappingBox.close();
                            }
                        }
                        finally {
                            try {
                                if (this.roiDescriptionBox != null) {
                                    this.roiDescriptionBox.close();
                                }
                            }
                            finally {
                                try {
                                    if (this.intellectualPropertyBox != null) {
                                        this.intellectualPropertyBox.close();
                                    }
                                }
                                finally {
                                    try {
                                        if (this.crossReferenceBox != null) {
                                            this.crossReferenceBox.close();
                                        }
                                    }
                                    finally {
                                        this.boxInfo.clearContents();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

