/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;
import java.util.ArrayList;

public class ComponentMappingBox
extends Jpeg2000Box {
    private ArrayList<Integer> cmp;
    private ArrayList<Integer> mtyp;
    private ArrayList<Integer> pcol;

    ComponentMappingBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public ArrayList<Integer> getCMPList() throws IOException {
        this.lazilyPopulateFields();
        return this.cmp;
    }

    public ArrayList<Integer> getMTYPList() throws IOException {
        this.lazilyPopulateFields();
        return this.mtyp;
    }

    public ArrayList<Integer> getPCOLList() throws IOException {
        this.lazilyPopulateFields();
        return this.pcol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.cmp = new ArrayList();
            this.mtyp = new ArrayList();
            this.pcol = new ArrayList();
            while (boxContents.bytesAvailable() > 0L) {
                this.cmp.add(Jpeg2000Utils.bytesToInteger(boxContents, 2));
                this.mtyp.add(Jpeg2000Utils.bytesToInteger(boxContents, 1));
                this.pcol.add(Jpeg2000Utils.bytesToInteger(boxContents, 1));
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

