/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;
import java.util.ArrayList;

public class NumberListBox
extends Jpeg2000Box {
    private ArrayList<Long> associateNumbersList;

    NumberListBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public ArrayList<Long> getAssociateNumbersList() throws IOException {
        this.lazilyPopulateFields();
        return this.associateNumbersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.associateNumbersList = new ArrayList();
            while (boxContents.bytesAvailable() > 0L) {
                this.associateNumbersList.add(Jpeg2000Utils.bytesToLong(boxContents, 4));
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

