/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class UUIDListBox
extends Jpeg2000Box {
    private int numberOfUUIDs;
    private InputByteStream[] idList;

    UUIDListBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getNumberOfUUIDs() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfUUIDs;
    }

    public InputByteStream[] getIDList() throws IOException {
        this.lazilyPopulateFields();
        return this.idList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.numberOfUUIDs = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.idList = new InputByteStream[this.numberOfUUIDs];
            for (int i = 0; i < this.numberOfUUIDs; ++i) {
                this.idList[i] = boxContents.slice(boxContents.getPosition(), 16L);
                boxContents.seek(boxContents.getPosition() + 16L);
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        IOException exceptionOccured = null;
        try {
            for (int i = 0; i < this.numberOfUUIDs; ++i) {
                try {
                    if (this.idList[i] == null) continue;
                    this.idList[i].close();
                    continue;
                }
                catch (IOException e) {
                    exceptionOccured = e;
                }
            }
            if (exceptionOccured != null) {
                throw exceptionOccured;
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

