/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap;

import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFPaperMetaData;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldBarcode;
import com.adobe.internal.pdftoolkit.services.ap.extension.APExtensionException;
import com.adobe.internal.pdftoolkit.services.ap.extension.BarcodeApProvider;
import com.adobe.internal.pdftoolkit.services.ap.impl.barcode.PMDBarcode;

public class BarcodeAPProviderImpl
implements BarcodeApProvider {
    @Override
    public void generateAppearance(PDFFieldBarcode field) throws APExtensionException {
        try {
            PDFAnnotation annotation;
            PDFAnnotationWidget barcodeWidgetAnnot = null;
            PDFAnnotationIterator barcodeAnnotationIterator = field.getAnnotationsIterator();
            if (barcodeAnnotationIterator != null && barcodeAnnotationIterator.hasNext() && (annotation = barcodeAnnotationIterator.next()) instanceof PDFAnnotationWidget) {
                barcodeWidgetAnnot = (PDFAnnotationWidget)annotation;
            }
            if (barcodeWidgetAnnot != null) {
                PDFPaperMetaData paperMetaData = barcodeWidgetAnnot.getPMD();
                PDFXObjectForm normalApp = PMDBarcode.updateImage((PDFPaperMetaData)paperMetaData, (PDFAnnotationWidget)barcodeWidgetAnnot, (PDFFieldBarcode)field);
                PDFAppearance app = barcodeWidgetAnnot.getAppearance();
                if (app == null) {
                    app = PDFAppearance.newInstance(field.getPDFDocument());
                    barcodeWidgetAnnot.setAppearance(app);
                }
                app.setNormalAppearance(normalApp);
            }
        }
        catch (Exception e) {
            throw new APExtensionException("Error generating barcode field appearance", e);
        }
    }
}

