/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap;

public class StyleAttributes {
    private static final String BASELINE_SHIFT = "; baseline-shift:";
    private static final String COLLAPSIBLE_TRAILING_SPACES = "; collapsible-trailing-spaces:";
    private static final String DELETE_TRAILING_SPACES = "; delete-trailing-spaces:";
    private static final String SPACE_BEFORE = "; space-before:";
    private static final String SPACE_AFTER = "; space-after:";
    private static final String LEFT_INDENT = "; indent-start:";
    private static final String RIGHT_INDENT = "; indent-end:";
    private static final String INCLUDE_TRAILING_SPACES_TO_COMPUTE_FONT_SIZE = "; include-trailing-spaces-to-compute-font-size:";
    private static final String LINE_HEIGHT = "; line-height:";
    private static final String LETTERSPACING = "; letterspacing:";
    private static final String WORDSPACING = "; wordspacing:";
    private static final String FONT_STRETCH_FACTOR = "; font-stretch-factor:";
    private static final String FONT_FORCE_MONOSPACE_PITCH = "; font-force-monospace-pitch:";
    private static final String FONT_FAMILY = "; font-family:";
    private static final String FONT_STYLE = "; font-style:";
    private static final String FONT_WEIGHT = "; font-weight:";
    private static final String FONT_VARIANT = "; font-variant";
    private static final String COLOR_START = "; color:#";
    private static final String COLOR_END = "";
    private static final String STYLE_START = "font: \"";
    private static final String STYLE_DELIM_QUOTE = "\" ";
    private static final String SIZE_END = "pt";
    private static final String EM = "em";
    private static final String ALIGNMENT_START = "; text-align:";
    private static final String[] TEXT_ALIGNMENT = new String[]{"left", "center", "right", "justify", "justify-all"};
    private static final String LOCALE_START = "; locale:";
    private static final String PRESERVE_SPACE = ";space:preserve";
    private static final String LINE_HEIGHT_PRECEDENCE_OVERRIDE = "; line-height-precedence-override:";
    public static final String UNDERLINE_SINGLE_ALL = "underline";
    public static final String UNDERLINE_SINGLE_WORD = "word";
    public static final String UNDERLINE_DOUBLE_ALL = "double";
    public static final String UNDERLINE_DOUBLE_WORD = "double word";
    public static final String STRIKE_THROUGH_SINGLE = "line-through";
    public static final String STRIKE_THROUGH_DOUBLE = "double-line-through";
    private static final String UNDERLINE = "; text-decoration.underline:";
    private static final String STRIKE_THROUGH = "; text-decoration.line-through:";
    private static final String TEXT_INDENT = "; text-indent:";
    public static final int TEXT_MEASUREMENT_TYPE_LENGTH = 0;
    public static final int TEXT_MEASUREMENT_TYPE_PERCENT = 2;
    private String styleString;
    private double fontSize;
    private String realFontName;
    private String fontName;
    private String fontFamily;
    private String fontStyle;
    private String fontWeight;
    private String fontVariant;
    private int textAlignment;
    private String fontColor;
    private String baselineShift;
    private String lineHeight;
    private String letterSpacing;
    private int letterSpacingUnit;
    private String wordSpacing;
    private String fontStretchFactor;
    private String fontForceMonospacePitch;
    private String locale;
    private String lineHeightPrecedenceOverride;
    private String textDecorationUnderline;
    private String textDecorationStrikeThrough;
    private String textIndent;
    private boolean discardLineHeightConditionality = true;
    private boolean collapsibleTrailingSpaces = true;
    private boolean deleteTrailingSpaces = false;
    private boolean includeTrailingSpacesToComputeFontSize = false;
    private String spaceBefore;
    private String spaceAfter;
    private String leftIndent;
    private String rightIndent;

    public StyleAttributes(String styleString) {
        this.styleString = styleString;
    }

    public StyleAttributes(StyleAttributes styleAttr) {
        this.styleString = styleAttr.getStyleString();
        this.fontSize = styleAttr.getFontSize();
        this.realFontName = styleAttr.getRealFontName();
        this.fontName = styleAttr.getFontName();
        this.textAlignment = styleAttr.getTextAlignment();
        this.fontColor = styleAttr.getFontColor();
        this.baselineShift = styleAttr.getBaselineShift();
        this.lineHeight = styleAttr.getLineHeight();
        this.letterSpacing = styleAttr.getLetterSpacing();
        this.wordSpacing = styleAttr.getWordSpacing();
        this.fontStretchFactor = styleAttr.getFontStretchFactor();
        this.fontForceMonospacePitch = styleAttr.getFontForceMonospacePitch();
        this.locale = styleAttr.getLocale();
        this.lineHeightPrecedenceOverride = styleAttr.getLineHeightPrecedenceOverride();
        this.textDecorationUnderline = styleAttr.getTextDecorationUnderline();
        this.textDecorationStrikeThrough = styleAttr.getTextDecorationStrikeThrough();
        this.textIndent = styleAttr.getTextIndent();
        this.letterSpacingUnit = styleAttr.getLetterSpacingUnit();
        this.collapsibleTrailingSpaces = styleAttr.collapsibleTrailingSpaces;
        this.deleteTrailingSpaces = styleAttr.deleteTrailingSpaces;
        this.includeTrailingSpacesToComputeFontSize = styleAttr.includeTrailingSpacesToComputeFontSize;
        this.discardLineHeightConditionality = styleAttr.discardLineHeightConditionality;
        this.spaceAfter = styleAttr.getSpaceAfter();
        this.spaceBefore = styleAttr.getSpaceBefore();
        this.leftIndent = styleAttr.getLeftIndent();
        this.rightIndent = styleAttr.getRightIndent();
        this.fontFamily = styleAttr.getFontFamily();
        this.fontStyle = styleAttr.getFontStyle();
        this.fontWeight = styleAttr.getFontWeight();
        this.fontVariant = styleAttr.getFontVariant();
    }

    public StyleAttributes() {
    }

    public StyleAttributes(double fontSize, String fontName, String realFontName) {
        this.fontSize = fontSize;
        this.fontName = fontName;
        this.realFontName = realFontName;
    }

    public String getStyleString() {
        StringBuilder retStyle = new StringBuilder(35);
        if (this.styleString != null) {
            retStyle.append(this.styleString);
        }
        if (this.realFontName != null && retStyle.indexOf("font") == -1) {
            retStyle.append(STYLE_START).append(this.realFontName).append(STYLE_DELIM_QUOTE).append(this.fontSize).append(SIZE_END);
        }
        if (this.fontFamily != null && retStyle.indexOf("font-family") == -1) {
            retStyle.append(FONT_FAMILY).append(this.fontFamily);
        }
        if (this.fontStyle != null && retStyle.indexOf("font-style") == -1) {
            retStyle.append(FONT_STYLE).append(this.fontStyle);
        }
        if (this.fontWeight != null && retStyle.indexOf("font-weight") == -1) {
            retStyle.append(FONT_WEIGHT).append(this.fontWeight);
        }
        if (retStyle.indexOf("text-align") == -1) {
            retStyle.append(ALIGNMENT_START + TEXT_ALIGNMENT[this.textAlignment]);
        }
        if (this.fontColor != null && retStyle.indexOf("color") == -1 && !this.fontColor.trim().equals(COLOR_END)) {
            retStyle.append(COLOR_START).append(this.fontColor).append(COLOR_END);
        }
        if (this.baselineShift != null && retStyle.indexOf("baseline-shift") == -1) {
            retStyle.append(BASELINE_SHIFT).append(this.baselineShift).append(SIZE_END);
        }
        if (this.spaceBefore != null && retStyle.indexOf("space-before") == -1) {
            retStyle.append(SPACE_BEFORE).append(this.spaceBefore).append(SIZE_END);
        }
        if (this.spaceAfter != null && retStyle.indexOf("space-after") == -1) {
            retStyle.append(SPACE_AFTER).append(this.spaceAfter).append(SIZE_END);
        }
        if (this.leftIndent != null && retStyle.indexOf("indent-start") == -1) {
            retStyle.append(LEFT_INDENT).append(this.leftIndent).append(SIZE_END);
        }
        if (this.rightIndent != null && retStyle.indexOf("indent-end") == -1) {
            retStyle.append(RIGHT_INDENT).append(this.rightIndent).append(SIZE_END);
        }
        if (this.lineHeight != null && retStyle.indexOf("line-height") == -1) {
            retStyle.append(LINE_HEIGHT).append(this.lineHeight).append(SIZE_END);
        }
        if (this.lineHeightPrecedenceOverride != null && this.styleString == null) {
            retStyle.append(LINE_HEIGHT_PRECEDENCE_OVERRIDE).append(this.lineHeightPrecedenceOverride);
        }
        if (this.letterSpacing != null && retStyle.indexOf("letterspacing") == -1) {
            if (this.letterSpacingUnit == 0) {
                retStyle.append(LETTERSPACING).append(this.letterSpacing).append(SIZE_END);
            } else {
                retStyle.append(LETTERSPACING).append(this.letterSpacing).append(EM);
            }
        }
        if (this.wordSpacing != null && retStyle.indexOf("wordspacing") == -1) {
            retStyle.append(WORDSPACING).append(this.wordSpacing).append(EM);
        }
        if (this.fontStretchFactor != null && retStyle.indexOf("font-stretch-factor") == -1) {
            retStyle.append(FONT_STRETCH_FACTOR).append(this.fontStretchFactor);
        }
        if (this.fontForceMonospacePitch != null && retStyle.indexOf("font-force-monospace-pitch") == -1) {
            retStyle.append(FONT_FORCE_MONOSPACE_PITCH).append(this.fontForceMonospacePitch).append(SIZE_END);
        }
        if (this.textDecorationUnderline != null && retStyle.indexOf(UNDERLINE_SINGLE_ALL) == -1) {
            retStyle.append(UNDERLINE).append(this.textDecorationUnderline);
        }
        if (this.textDecorationStrikeThrough != null && retStyle.indexOf(STRIKE_THROUGH_SINGLE) == -1) {
            retStyle.append(STRIKE_THROUGH).append(this.textDecorationStrikeThrough);
        }
        if (this.textIndent != null && retStyle.indexOf("text-indent") == -1) {
            retStyle.append(TEXT_INDENT).append(this.textIndent).append(SIZE_END);
        }
        if (this.locale != null) {
            retStyle.append(LOCALE_START).append(this.locale);
        }
        if (this.styleString == null && this.discardLineHeightConditionality) {
            retStyle.append(";line-height.conditionality:discard");
        }
        retStyle.append(COLLAPSIBLE_TRAILING_SPACES).append(this.collapsibleTrailingSpaces);
        retStyle.append(DELETE_TRAILING_SPACES).append(this.deleteTrailingSpaces);
        retStyle.append(INCLUDE_TRAILING_SPACES_TO_COMPUTE_FONT_SIZE).append(this.includeTrailingSpacesToComputeFontSize);
        return retStyle.toString() + PRESERVE_SPACE;
    }

    public String getBaselineShift() {
        return this.baselineShift;
    }

    public void setBaselineShift(String baselineShift) {
        this.baselineShift = baselineShift;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public String getFontForceMonospacePitch() {
        return this.fontForceMonospacePitch;
    }

    public void setFontForceMonospacePitch(String fontForceMonospacePitch) {
        this.fontForceMonospacePitch = fontForceMonospacePitch;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontStretchFactor() {
        return this.fontStretchFactor;
    }

    public void setFontStretchFactor(String fontStretchFactor) {
        this.fontStretchFactor = fontStretchFactor;
    }

    public String getLetterSpacing() {
        return this.letterSpacing;
    }

    public void setLetterSpacing(String letterSpacing) {
        this.letterSpacing = letterSpacing;
    }

    public String getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(String lineHeight) {
        this.lineHeight = lineHeight;
    }

    public String getLineHeightPrecedenceOverride() {
        return this.lineHeightPrecedenceOverride;
    }

    public void setLineHeightPrecedenceOverride(String lineHeightPrecedenceOverride) {
        this.lineHeightPrecedenceOverride = lineHeightPrecedenceOverride;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getRealFontName() {
        return this.realFontName;
    }

    public void setRealFontName(String realFontName) {
        this.realFontName = realFontName;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
    }

    public String getWordSpacing() {
        return this.wordSpacing;
    }

    public void setWordSpacing(String wordSpacing) {
        this.wordSpacing = wordSpacing;
    }

    public int getLetterSpacingUnit() {
        return this.letterSpacingUnit;
    }

    public void setLetterSpacingUnit(int letterSpacingUnit) {
        this.letterSpacingUnit = letterSpacingUnit;
    }

    public String getTextIndent() {
        return this.textIndent;
    }

    public void setTextIndent(String textIndent) {
        this.textIndent = textIndent;
    }

    public String getTextDecorationStrikeThrough() {
        return this.textDecorationStrikeThrough;
    }

    public void setTextDecorationStrikeThrough(String textDecorationStrikeThrough) {
        this.textDecorationStrikeThrough = textDecorationStrikeThrough;
    }

    public String getTextDecorationUnderline() {
        return this.textDecorationUnderline;
    }

    public void setTextDecorationUnderline(String textDecorationUnderline) {
        this.textDecorationUnderline = textDecorationUnderline;
    }

    public boolean isCollapsibleTrailingSpaces() {
        return this.collapsibleTrailingSpaces;
    }

    public void setCollapsibleTrailingSpaces(boolean collapsibleTrailingSpaces) {
        this.collapsibleTrailingSpaces = collapsibleTrailingSpaces;
    }

    public boolean isDeleteTrailingSpaces() {
        return this.deleteTrailingSpaces;
    }

    public void setDeleteTrailingSpaces(boolean deleteTrailingSpaces) {
        this.deleteTrailingSpaces = deleteTrailingSpaces;
    }

    public void setIncludeTrailingSpacesToComputeFontSize(boolean includeTrailingSpacesToComputeFontSize) {
        this.includeTrailingSpacesToComputeFontSize = includeTrailingSpacesToComputeFontSize;
    }

    public boolean isIncludeTrailingSpacesToComputeFontSize() {
        return this.includeTrailingSpacesToComputeFontSize;
    }

    public boolean isDiscardLineHeightConditionality() {
        return this.discardLineHeightConditionality;
    }

    public void setDiscardLineHeightConditionality(boolean discardLineHeightConditionality) {
        this.discardLineHeightConditionality = discardLineHeightConditionality;
    }

    public void setSpaceBefore(String spaceBefore) {
        this.spaceBefore = spaceBefore;
    }

    public String getSpaceBefore() {
        return this.spaceBefore;
    }

    public void setSpaceAfter(String spaceAfter) {
        this.spaceAfter = spaceAfter;
    }

    public String getSpaceAfter() {
        return this.spaceAfter;
    }

    public void setLeftIndent(String leftIndent) {
        this.leftIndent = leftIndent;
    }

    public String getLeftIndent() {
        return this.leftIndent;
    }

    public void setRightIndent(String rightIndent) {
        this.rightIndent = rightIndent;
    }

    public String getRightIndent() {
        return this.rightIndent;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(int fontWeight) {
        Integer fw = new Integer(fontWeight);
        this.fontWeight = fw.toString();
    }

    public void setFontVariant(String fontVariant) {
        this.fontVariant = fontVariant;
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baselineShift == null ? 0 : this.baselineShift.hashCode());
        result = 31 * result + (this.collapsibleTrailingSpaces ? 1231 : 1237);
        result = 31 * result + (this.deleteTrailingSpaces ? 1231 : 1237);
        result = 31 * result + (this.discardLineHeightConditionality ? 1231 : 1237);
        result = 31 * result + (this.fontColor == null ? 0 : this.fontColor.hashCode());
        result = 31 * result + (this.fontFamily == null ? 0 : this.fontFamily.hashCode());
        result = 31 * result + (this.fontForceMonospacePitch == null ? 0 : this.fontForceMonospacePitch.hashCode());
        result = 31 * result + (this.fontName == null ? 0 : this.fontName.hashCode());
        long temp = Double.doubleToLongBits(this.fontSize);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.fontStretchFactor == null ? 0 : this.fontStretchFactor.hashCode());
        result = 31 * result + (this.fontStyle == null ? 0 : this.fontStyle.hashCode());
        result = 31 * result + (this.fontVariant == null ? 0 : this.fontVariant.hashCode());
        result = 31 * result + (this.fontWeight == null ? 0 : this.fontWeight.hashCode());
        result = 31 * result + (this.includeTrailingSpacesToComputeFontSize ? 1231 : 1237);
        result = 31 * result + (this.leftIndent == null ? 0 : this.leftIndent.hashCode());
        result = 31 * result + (this.letterSpacing == null ? 0 : this.letterSpacing.hashCode());
        result = 31 * result + this.letterSpacingUnit;
        result = 31 * result + (this.lineHeight == null ? 0 : this.lineHeight.hashCode());
        result = 31 * result + (this.lineHeightPrecedenceOverride == null ? 0 : this.lineHeightPrecedenceOverride.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.realFontName == null ? 0 : this.realFontName.hashCode());
        result = 31 * result + (this.rightIndent == null ? 0 : this.rightIndent.hashCode());
        result = 31 * result + (this.spaceAfter == null ? 0 : this.spaceAfter.hashCode());
        result = 31 * result + (this.spaceBefore == null ? 0 : this.spaceBefore.hashCode());
        result = 31 * result + (this.styleString == null ? 0 : this.styleString.hashCode());
        result = 31 * result + this.textAlignment;
        result = 31 * result + (this.textDecorationStrikeThrough == null ? 0 : this.textDecorationStrikeThrough.hashCode());
        result = 31 * result + (this.textDecorationUnderline == null ? 0 : this.textDecorationUnderline.hashCode());
        result = 31 * result + (this.textIndent == null ? 0 : this.textIndent.hashCode());
        result = 31 * result + (this.wordSpacing == null ? 0 : this.wordSpacing.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StyleAttributes)) {
            return false;
        }
        StyleAttributes other = (StyleAttributes)obj;
        if (this.baselineShift == null ? other.baselineShift != null : !this.baselineShift.equals(other.baselineShift)) {
            return false;
        }
        if (this.collapsibleTrailingSpaces != other.collapsibleTrailingSpaces) {
            return false;
        }
        if (this.deleteTrailingSpaces != other.deleteTrailingSpaces) {
            return false;
        }
        if (this.discardLineHeightConditionality != other.discardLineHeightConditionality) {
            return false;
        }
        if (this.fontColor == null ? other.fontColor != null : !this.fontColor.equals(other.fontColor)) {
            return false;
        }
        if (this.fontFamily == null ? other.fontFamily != null : !this.fontFamily.equals(other.fontFamily)) {
            return false;
        }
        if (this.fontForceMonospacePitch == null ? other.fontForceMonospacePitch != null : !this.fontForceMonospacePitch.equals(other.fontForceMonospacePitch)) {
            return false;
        }
        if (this.fontName == null ? other.fontName != null : !this.fontName.equals(other.fontName)) {
            return false;
        }
        if (Double.doubleToLongBits(this.fontSize) != Double.doubleToLongBits(other.fontSize)) {
            return false;
        }
        if (this.fontStretchFactor == null ? other.fontStretchFactor != null : !this.fontStretchFactor.equals(other.fontStretchFactor)) {
            return false;
        }
        if (this.fontStyle == null ? other.fontStyle != null : !this.fontStyle.equals(other.fontStyle)) {
            return false;
        }
        if (this.fontVariant == null ? other.fontVariant != null : !this.fontVariant.equals(other.fontVariant)) {
            return false;
        }
        if (this.fontWeight == null ? other.fontWeight != null : !this.fontWeight.equals(other.fontWeight)) {
            return false;
        }
        if (this.includeTrailingSpacesToComputeFontSize != other.includeTrailingSpacesToComputeFontSize) {
            return false;
        }
        if (this.leftIndent == null ? other.leftIndent != null : !this.leftIndent.equals(other.leftIndent)) {
            return false;
        }
        if (this.letterSpacing == null ? other.letterSpacing != null : !this.letterSpacing.equals(other.letterSpacing)) {
            return false;
        }
        if (this.letterSpacingUnit != other.letterSpacingUnit) {
            return false;
        }
        if (this.lineHeight == null ? other.lineHeight != null : !this.lineHeight.equals(other.lineHeight)) {
            return false;
        }
        if (this.lineHeightPrecedenceOverride == null ? other.lineHeightPrecedenceOverride != null : !this.lineHeightPrecedenceOverride.equals(other.lineHeightPrecedenceOverride)) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.realFontName == null ? other.realFontName != null : !this.realFontName.equals(other.realFontName)) {
            return false;
        }
        if (this.rightIndent == null ? other.rightIndent != null : !this.rightIndent.equals(other.rightIndent)) {
            return false;
        }
        if (this.spaceAfter == null ? other.spaceAfter != null : !this.spaceAfter.equals(other.spaceAfter)) {
            return false;
        }
        if (this.spaceBefore == null ? other.spaceBefore != null : !this.spaceBefore.equals(other.spaceBefore)) {
            return false;
        }
        if (this.styleString == null ? other.styleString != null : !this.styleString.equals(other.styleString)) {
            return false;
        }
        if (this.textAlignment != other.textAlignment) {
            return false;
        }
        if (this.textDecorationStrikeThrough == null ? other.textDecorationStrikeThrough != null : !this.textDecorationStrikeThrough.equals(other.textDecorationStrikeThrough)) {
            return false;
        }
        if (this.textDecorationUnderline == null ? other.textDecorationUnderline != null : !this.textDecorationUnderline.equals(other.textDecorationUnderline)) {
            return false;
        }
        if (this.textIndent == null ? other.textIndent != null : !this.textIndent.equals(other.textIndent)) {
            return false;
        }
        return !(this.wordSpacing == null ? other.wordSpacing != null : !this.wordSpacing.equals(other.wordSpacing));
    }
}

